package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "city", 
    "countryCode", 
    "countryName", 
    "defaultDomainName", 
    "displayName", 
    "industryName", 
    "region", 
    "segmentName", 
    "tenantId", 
    "verticalName"})
@JsonInclude(Include.NON_NULL)
public class TenantDetailedInformation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantDetailedInformation";
    }

    @JsonProperty("city")
    protected String city;

    @JsonProperty("countryCode")
    protected String countryCode;

    @JsonProperty("countryName")
    protected String countryName;

    @JsonProperty("defaultDomainName")
    protected String defaultDomainName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("industryName")
    protected String industryName;

    @JsonProperty("region")
    protected String region;

    @JsonProperty("segmentName")
    protected String segmentName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("verticalName")
    protected String verticalName;

    protected TenantDetailedInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantDetailedInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String city;
        private String countryCode;
        private String countryName;
        private String defaultDomainName;
        private String displayName;
        private String industryName;
        private String region;
        private String segmentName;
        private String tenantId;
        private String verticalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.changedFields = changedFields.add("countryCode");
            return this;
        }

        public Builder countryName(String countryName) {
            this.countryName = countryName;
            this.changedFields = changedFields.add("countryName");
            return this;
        }

        public Builder defaultDomainName(String defaultDomainName) {
            this.defaultDomainName = defaultDomainName;
            this.changedFields = changedFields.add("defaultDomainName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder industryName(String industryName) {
            this.industryName = industryName;
            this.changedFields = changedFields.add("industryName");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.changedFields = changedFields.add("region");
            return this;
        }

        public Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            this.changedFields = changedFields.add("segmentName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder verticalName(String verticalName) {
            this.verticalName = verticalName;
            this.changedFields = changedFields.add("verticalName");
            return this;
        }

        public TenantDetailedInformation build() {
            TenantDetailedInformation _x = new TenantDetailedInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantDetailedInformation";
            _x.id = id;
            _x.city = city;
            _x.countryCode = countryCode;
            _x.countryName = countryName;
            _x.defaultDomainName = defaultDomainName;
            _x.displayName = displayName;
            _x.industryName = industryName;
            _x.region = region;
            _x.segmentName = segmentName;
            _x.tenantId = tenantId;
            _x.verticalName = verticalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public TenantDetailedInformation withCity(String city) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("city");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.city = city;
        return _x;
    }

    @Property(name="countryCode")
    @JsonIgnore
    public Optional<String> getCountryCode() {
        return Optional.ofNullable(countryCode);
    }

    public TenantDetailedInformation withCountryCode(String countryCode) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("countryCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.countryCode = countryCode;
        return _x;
    }

    @Property(name="countryName")
    @JsonIgnore
    public Optional<String> getCountryName() {
        return Optional.ofNullable(countryName);
    }

    public TenantDetailedInformation withCountryName(String countryName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("countryName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.countryName = countryName;
        return _x;
    }

    @Property(name="defaultDomainName")
    @JsonIgnore
    public Optional<String> getDefaultDomainName() {
        return Optional.ofNullable(defaultDomainName);
    }

    public TenantDetailedInformation withDefaultDomainName(String defaultDomainName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("defaultDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.defaultDomainName = defaultDomainName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TenantDetailedInformation withDisplayName(String displayName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="industryName")
    @JsonIgnore
    public Optional<String> getIndustryName() {
        return Optional.ofNullable(industryName);
    }

    public TenantDetailedInformation withIndustryName(String industryName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("industryName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.industryName = industryName;
        return _x;
    }

    @Property(name="region")
    @JsonIgnore
    public Optional<String> getRegion() {
        return Optional.ofNullable(region);
    }

    public TenantDetailedInformation withRegion(String region) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("region");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.region = region;
        return _x;
    }

    @Property(name="segmentName")
    @JsonIgnore
    public Optional<String> getSegmentName() {
        return Optional.ofNullable(segmentName);
    }

    public TenantDetailedInformation withSegmentName(String segmentName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("segmentName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.segmentName = segmentName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public TenantDetailedInformation withTenantId(String tenantId) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="verticalName")
    @JsonIgnore
    public Optional<String> getVerticalName() {
        return Optional.ofNullable(verticalName);
    }

    public TenantDetailedInformation withVerticalName(String verticalName) {
        TenantDetailedInformation _x = _copy();
        _x.changedFields = changedFields.add("verticalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantDetailedInformation");
        _x.verticalName = verticalName;
        return _x;
    }

    public TenantDetailedInformation withUnmappedField(String name, Object value) {
        TenantDetailedInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantDetailedInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantDetailedInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantDetailedInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantDetailedInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantDetailedInformation _copy() {
        TenantDetailedInformation _x = new TenantDetailedInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.city = city;
        _x.countryCode = countryCode;
        _x.countryName = countryName;
        _x.defaultDomainName = defaultDomainName;
        _x.displayName = displayName;
        _x.industryName = industryName;
        _x.region = region;
        _x.segmentName = segmentName;
        _x.tenantId = tenantId;
        _x.verticalName = verticalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantDetailedInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("countryCode=");
        b.append(this.countryCode);
        b.append(", ");
        b.append("countryName=");
        b.append(this.countryName);
        b.append(", ");
        b.append("defaultDomainName=");
        b.append(this.defaultDomainName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("industryName=");
        b.append(this.industryName);
        b.append(", ");
        b.append("region=");
        b.append(this.region);
        b.append(", ");
        b.append("segmentName=");
        b.append(this.segmentName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("verticalName=");
        b.append(this.verticalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
