package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepDeploymentCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "contentMarkdown", 
    "createdByUserId", 
    "createdDateTime", 
    "lastActionByUserId", 
    "lastActionDateTime", 
    "name", 
    "version", 
    "versionInformation"})
@JsonInclude(Include.NON_NULL)
public class ManagementTemplateStepVersion extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementTemplateStepVersion";
    }

    @JsonProperty("contentMarkdown")
    protected String contentMarkdown;

    @JsonProperty("createdByUserId")
    protected String createdByUserId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastActionByUserId")
    protected String lastActionByUserId;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("versionInformation")
    protected String versionInformation;

    protected ManagementTemplateStepVersion() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementTemplateStepVersion() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String contentMarkdown;
        private String createdByUserId;
        private OffsetDateTime createdDateTime;
        private String lastActionByUserId;
        private OffsetDateTime lastActionDateTime;
        private String name;
        private Integer version;
        private String versionInformation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder contentMarkdown(String contentMarkdown) {
            this.contentMarkdown = contentMarkdown;
            this.changedFields = changedFields.add("contentMarkdown");
            return this;
        }

        public Builder createdByUserId(String createdByUserId) {
            this.createdByUserId = createdByUserId;
            this.changedFields = changedFields.add("createdByUserId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastActionByUserId(String lastActionByUserId) {
            this.lastActionByUserId = lastActionByUserId;
            this.changedFields = changedFields.add("lastActionByUserId");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder versionInformation(String versionInformation) {
            this.versionInformation = versionInformation;
            this.changedFields = changedFields.add("versionInformation");
            return this;
        }

        public ManagementTemplateStepVersion build() {
            ManagementTemplateStepVersion _x = new ManagementTemplateStepVersion();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementTemplateStepVersion";
            _x.id = id;
            _x.contentMarkdown = contentMarkdown;
            _x.createdByUserId = createdByUserId;
            _x.createdDateTime = createdDateTime;
            _x.lastActionByUserId = lastActionByUserId;
            _x.lastActionDateTime = lastActionDateTime;
            _x.name = name;
            _x.version = version;
            _x.versionInformation = versionInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contentMarkdown")
    @JsonIgnore
    public Optional<String> getContentMarkdown() {
        return Optional.ofNullable(contentMarkdown);
    }

    public ManagementTemplateStepVersion withContentMarkdown(String contentMarkdown) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("contentMarkdown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.contentMarkdown = contentMarkdown;
        return _x;
    }

    @Property(name="createdByUserId")
    @JsonIgnore
    public Optional<String> getCreatedByUserId() {
        return Optional.ofNullable(createdByUserId);
    }

    public ManagementTemplateStepVersion withCreatedByUserId(String createdByUserId) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("createdByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.createdByUserId = createdByUserId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ManagementTemplateStepVersion withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastActionByUserId")
    @JsonIgnore
    public Optional<String> getLastActionByUserId() {
        return Optional.ofNullable(lastActionByUserId);
    }

    public ManagementTemplateStepVersion withLastActionByUserId(String lastActionByUserId) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("lastActionByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.lastActionByUserId = lastActionByUserId;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public ManagementTemplateStepVersion withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ManagementTemplateStepVersion withName(String name) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.name = name;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public ManagementTemplateStepVersion withVersion(Integer version) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.version = version;
        return _x;
    }

    @Property(name="versionInformation")
    @JsonIgnore
    public Optional<String> getVersionInformation() {
        return Optional.ofNullable(versionInformation);
    }

    public ManagementTemplateStepVersion withVersionInformation(String versionInformation) {
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = changedFields.add("versionInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepVersion");
        _x.versionInformation = versionInformation;
        return _x;
    }

    public ManagementTemplateStepVersion withUnmappedField(String name, Object value) {
        ManagementTemplateStepVersion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="acceptedFor")
    @JsonIgnore
    public ManagementTemplateStepRequest getAcceptedFor() {
        return new ManagementTemplateStepRequest(contextPath.addSegment("acceptedFor"), RequestHelper.getValue(unmappedFields, "acceptedFor"));
    }

    @NavigationProperty(name="deployments")
    @JsonIgnore
    public ManagementTemplateStepDeploymentCollectionRequest getDeployments() {
        return new ManagementTemplateStepDeploymentCollectionRequest(
                        contextPath.addSegment("deployments"), RequestHelper.getValue(unmappedFields, "deployments"));
    }

    @NavigationProperty(name="templateStep")
    @JsonIgnore
    public ManagementTemplateStepRequest getTemplateStep() {
        return new ManagementTemplateStepRequest(contextPath.addSegment("templateStep"), RequestHelper.getValue(unmappedFields, "templateStep"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStepVersion patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStepVersion put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStepVersion _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementTemplateStepVersion _copy() {
        ManagementTemplateStepVersion _x = new ManagementTemplateStepVersion();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.contentMarkdown = contentMarkdown;
        _x.createdByUserId = createdByUserId;
        _x.createdDateTime = createdDateTime;
        _x.lastActionByUserId = lastActionByUserId;
        _x.lastActionDateTime = lastActionDateTime;
        _x.name = name;
        _x.version = version;
        _x.versionInformation = versionInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementTemplateStepVersion[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("contentMarkdown=");
        b.append(this.contentMarkdown);
        b.append(", ");
        b.append("createdByUserId=");
        b.append(this.createdByUserId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastActionByUserId=");
        b.append(this.lastActionByUserId);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("versionInformation=");
        b.append(this.versionInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
