package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.GraphAPIErrorDetails;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepVersionRequest;
import odata.msgraph.client.beta.managed.tenants.enums.ManagementTemplateDeploymentStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "createdByUserId", 
    "createdDateTime", 
    "error", 
    "lastActionByUserId", 
    "lastActionDateTime", 
    "status", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class ManagementTemplateStepDeployment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementTemplateStepDeployment";
    }

    @JsonProperty("createdByUserId")
    protected String createdByUserId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("error")
    protected GraphAPIErrorDetails error;

    @JsonProperty("lastActionByUserId")
    protected String lastActionByUserId;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("status")
    protected ManagementTemplateDeploymentStatus status;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected ManagementTemplateStepDeployment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementTemplateStepDeployment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String createdByUserId;
        private OffsetDateTime createdDateTime;
        private GraphAPIErrorDetails error;
        private String lastActionByUserId;
        private OffsetDateTime lastActionDateTime;
        private ManagementTemplateDeploymentStatus status;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdByUserId(String createdByUserId) {
            this.createdByUserId = createdByUserId;
            this.changedFields = changedFields.add("createdByUserId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder error(GraphAPIErrorDetails error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastActionByUserId(String lastActionByUserId) {
            this.lastActionByUserId = lastActionByUserId;
            this.changedFields = changedFields.add("lastActionByUserId");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder status(ManagementTemplateDeploymentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public ManagementTemplateStepDeployment build() {
            ManagementTemplateStepDeployment _x = new ManagementTemplateStepDeployment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementTemplateStepDeployment";
            _x.id = id;
            _x.createdByUserId = createdByUserId;
            _x.createdDateTime = createdDateTime;
            _x.error = error;
            _x.lastActionByUserId = lastActionByUserId;
            _x.lastActionDateTime = lastActionDateTime;
            _x.status = status;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdByUserId")
    @JsonIgnore
    public Optional<String> getCreatedByUserId() {
        return Optional.ofNullable(createdByUserId);
    }

    public ManagementTemplateStepDeployment withCreatedByUserId(String createdByUserId) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("createdByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.createdByUserId = createdByUserId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ManagementTemplateStepDeployment withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<GraphAPIErrorDetails> getError() {
        return Optional.ofNullable(error);
    }

    public ManagementTemplateStepDeployment withError(GraphAPIErrorDetails error) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.error = error;
        return _x;
    }

    @Property(name="lastActionByUserId")
    @JsonIgnore
    public Optional<String> getLastActionByUserId() {
        return Optional.ofNullable(lastActionByUserId);
    }

    public ManagementTemplateStepDeployment withLastActionByUserId(String lastActionByUserId) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("lastActionByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.lastActionByUserId = lastActionByUserId;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public ManagementTemplateStepDeployment withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ManagementTemplateDeploymentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ManagementTemplateStepDeployment withStatus(ManagementTemplateDeploymentStatus status) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.status = status;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ManagementTemplateStepDeployment withTenantId(String tenantId) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateStepDeployment");
        _x.tenantId = tenantId;
        return _x;
    }

    public ManagementTemplateStepDeployment withUnmappedField(String name, Object value) {
        ManagementTemplateStepDeployment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="templateStepVersion")
    @JsonIgnore
    public ManagementTemplateStepVersionRequest getTemplateStepVersion() {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("templateStepVersion"), RequestHelper.getValue(unmappedFields, "templateStepVersion"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStepDeployment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementTemplateStepDeployment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementTemplateStepDeployment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementTemplateStepDeployment _copy() {
        ManagementTemplateStepDeployment _x = new ManagementTemplateStepDeployment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdByUserId = createdByUserId;
        _x.createdDateTime = createdDateTime;
        _x.error = error;
        _x.lastActionByUserId = lastActionByUserId;
        _x.lastActionDateTime = lastActionDateTime;
        _x.status = status;
        _x.tenantId = tenantId;
        return _x;
    }

    @Action(name = "changeDeploymentStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ManagementTemplateStepDeployment> changeDeploymentStatus(String tenantId, String managementTemplateStepId, String status) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("managementTemplateStepId", "Edm.String", Checks.checkIsAscii(managementTemplateStepId))
            .put("status", "Edm.String", Checks.checkIsAscii(status))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ManagementTemplateStepDeployment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.changeDeploymentStatus"), ManagementTemplateStepDeployment.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementTemplateStepDeployment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdByUserId=");
        b.append(this.createdByUserId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastActionByUserId=");
        b.append(this.lastActionByUserId);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
