package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.ManagementTemplateDetailedInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isGlobal", 
    "managementTemplates"})
@JsonInclude(Include.NON_NULL)
public class ManagementIntent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementIntent";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isGlobal")
    protected Boolean isGlobal;

    @JsonProperty("managementTemplates")
    protected List<ManagementTemplateDetailedInfo> managementTemplates;

    @JsonProperty("managementTemplates@nextLink")
    protected String managementTemplatesNextLink;

    protected ManagementIntent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementIntent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isGlobal;
        private List<ManagementTemplateDetailedInfo> managementTemplates;
        private String managementTemplatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("isGlobal");
            return this;
        }

        public Builder managementTemplates(List<ManagementTemplateDetailedInfo> managementTemplates) {
            this.managementTemplates = managementTemplates;
            this.changedFields = changedFields.add("managementTemplates");
            return this;
        }

        public Builder managementTemplates(ManagementTemplateDetailedInfo... managementTemplates) {
            return managementTemplates(Arrays.asList(managementTemplates));
        }

        public Builder managementTemplatesNextLink(String managementTemplatesNextLink) {
            this.managementTemplatesNextLink = managementTemplatesNextLink;
            this.changedFields = changedFields.add("managementTemplates");
            return this;
        }

        public ManagementIntent build() {
            ManagementIntent _x = new ManagementIntent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementIntent";
            _x.id = id;
            _x.displayName = displayName;
            _x.isGlobal = isGlobal;
            _x.managementTemplates = managementTemplates;
            _x.managementTemplatesNextLink = managementTemplatesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagementIntent withDisplayName(String displayName) {
        ManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementIntent");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isGlobal")
    @JsonIgnore
    public Optional<Boolean> getIsGlobal() {
        return Optional.ofNullable(isGlobal);
    }

    public ManagementIntent withIsGlobal(Boolean isGlobal) {
        ManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("isGlobal");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementIntent");
        _x.isGlobal = isGlobal;
        return _x;
    }

    @Property(name="managementTemplates")
    @JsonIgnore
    public CollectionPage<ManagementTemplateDetailedInfo> getManagementTemplates() {
        return new CollectionPage<ManagementTemplateDetailedInfo>(contextPath, ManagementTemplateDetailedInfo.class, this.managementTemplates, Optional.ofNullable(managementTemplatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementIntent withManagementTemplates(List<ManagementTemplateDetailedInfo> managementTemplates) {
        ManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("managementTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementIntent");
        _x.managementTemplates = managementTemplates;
        return _x;
    }

    @Property(name="managementTemplates")
    @JsonIgnore
    public CollectionPage<ManagementTemplateDetailedInfo> getManagementTemplates(HttpRequestOptions options) {
        return new CollectionPage<ManagementTemplateDetailedInfo>(contextPath, ManagementTemplateDetailedInfo.class, this.managementTemplates, Optional.ofNullable(managementTemplatesNextLink), Collections.emptyList(), options);
    }

    public ManagementIntent withUnmappedField(String name, Object value) {
        ManagementIntent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementIntent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementIntent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementIntent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementIntent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementIntent _copy() {
        ManagementIntent _x = new ManagementIntent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isGlobal = isGlobal;
        _x.managementTemplates = managementTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementIntent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("managementTemplates=");
        b.append(this.managementTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
