package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.ManagementActionDeploymentStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "statuses", 
    "tenantGroupId", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class ManagementActionTenantDeploymentStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementActionTenantDeploymentStatus";
    }

    @JsonProperty("statuses")
    protected List<ManagementActionDeploymentStatus> statuses;

    @JsonProperty("statuses@nextLink")
    protected String statusesNextLink;

    @JsonProperty("tenantGroupId")
    protected String tenantGroupId;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected ManagementActionTenantDeploymentStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagementActionTenantDeploymentStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ManagementActionDeploymentStatus> statuses;
        private String statusesNextLink;
        private String tenantGroupId;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder statuses(List<ManagementActionDeploymentStatus> statuses) {
            this.statuses = statuses;
            this.changedFields = changedFields.add("statuses");
            return this;
        }

        public Builder statuses(ManagementActionDeploymentStatus... statuses) {
            return statuses(Arrays.asList(statuses));
        }

        public Builder statusesNextLink(String statusesNextLink) {
            this.statusesNextLink = statusesNextLink;
            this.changedFields = changedFields.add("statuses");
            return this;
        }

        public Builder tenantGroupId(String tenantGroupId) {
            this.tenantGroupId = tenantGroupId;
            this.changedFields = changedFields.add("tenantGroupId");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public ManagementActionTenantDeploymentStatus build() {
            ManagementActionTenantDeploymentStatus _x = new ManagementActionTenantDeploymentStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementActionTenantDeploymentStatus";
            _x.id = id;
            _x.statuses = statuses;
            _x.statusesNextLink = statusesNextLink;
            _x.tenantGroupId = tenantGroupId;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="statuses")
    @JsonIgnore
    public CollectionPage<ManagementActionDeploymentStatus> getStatuses() {
        return new CollectionPage<ManagementActionDeploymentStatus>(contextPath, ManagementActionDeploymentStatus.class, this.statuses, Optional.ofNullable(statusesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ManagementActionTenantDeploymentStatus withStatuses(List<ManagementActionDeploymentStatus> statuses) {
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("statuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionTenantDeploymentStatus");
        _x.statuses = statuses;
        return _x;
    }

    @Property(name="statuses")
    @JsonIgnore
    public CollectionPage<ManagementActionDeploymentStatus> getStatuses(HttpRequestOptions options) {
        return new CollectionPage<ManagementActionDeploymentStatus>(contextPath, ManagementActionDeploymentStatus.class, this.statuses, Optional.ofNullable(statusesNextLink), Collections.emptyList(), options);
    }

    @Property(name="tenantGroupId")
    @JsonIgnore
    public Optional<String> getTenantGroupId() {
        return Optional.ofNullable(tenantGroupId);
    }

    public ManagementActionTenantDeploymentStatus withTenantGroupId(String tenantGroupId) {
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("tenantGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionTenantDeploymentStatus");
        _x.tenantGroupId = tenantGroupId;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ManagementActionTenantDeploymentStatus withTenantId(String tenantId) {
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionTenantDeploymentStatus");
        _x.tenantId = tenantId;
        return _x;
    }

    public ManagementActionTenantDeploymentStatus withUnmappedField(String name, Object value) {
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementActionTenantDeploymentStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementActionTenantDeploymentStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementActionTenantDeploymentStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementActionTenantDeploymentStatus _copy() {
        ManagementActionTenantDeploymentStatus _x = new ManagementActionTenantDeploymentStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.statuses = statuses;
        _x.tenantGroupId = tenantGroupId;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementActionTenantDeploymentStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("statuses=");
        b.append(this.statuses);
        b.append(", ");
        b.append("tenantGroupId=");
        b.append(this.tenantGroupId);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
