package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "complianceStatus", 
    "deviceType", 
    "inGracePeriodUntilDateTime", 
    "lastRefreshedDateTime", 
    "lastSyncDateTime", 
    "managedDeviceId", 
    "managedDeviceName", 
    "manufacturer", 
    "model", 
    "osDescription", 
    "osVersion", 
    "ownerType", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceCompliance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managedDeviceCompliance";
    }

    @JsonProperty("complianceStatus")
    protected String complianceStatus;

    @JsonProperty("deviceType")
    protected String deviceType;

    @JsonProperty("inGracePeriodUntilDateTime")
    protected OffsetDateTime inGracePeriodUntilDateTime;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("ownerType")
    protected String ownerType;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected ManagedDeviceCompliance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceCompliance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String complianceStatus;
        private String deviceType;
        private OffsetDateTime inGracePeriodUntilDateTime;
        private OffsetDateTime lastRefreshedDateTime;
        private OffsetDateTime lastSyncDateTime;
        private String managedDeviceId;
        private String managedDeviceName;
        private String manufacturer;
        private String model;
        private String osDescription;
        private String osVersion;
        private String ownerType;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            this.changedFields = changedFields.add("complianceStatus");
            return this;
        }

        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder inGracePeriodUntilDateTime(OffsetDateTime inGracePeriodUntilDateTime) {
            this.inGracePeriodUntilDateTime = inGracePeriodUntilDateTime;
            this.changedFields = changedFields.add("inGracePeriodUntilDateTime");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public ManagedDeviceCompliance build() {
            ManagedDeviceCompliance _x = new ManagedDeviceCompliance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managedDeviceCompliance";
            _x.id = id;
            _x.complianceStatus = complianceStatus;
            _x.deviceType = deviceType;
            _x.inGracePeriodUntilDateTime = inGracePeriodUntilDateTime;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.osDescription = osDescription;
            _x.osVersion = osVersion;
            _x.ownerType = ownerType;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="complianceStatus")
    @JsonIgnore
    public Optional<String> getComplianceStatus() {
        return Optional.ofNullable(complianceStatus);
    }

    public ManagedDeviceCompliance withComplianceStatus(String complianceStatus) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("complianceStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.complianceStatus = complianceStatus;
        return _x;
    }

    @Property(name="deviceType")
    @JsonIgnore
    public Optional<String> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    public ManagedDeviceCompliance withDeviceType(String deviceType) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.deviceType = deviceType;
        return _x;
    }

    @Property(name="inGracePeriodUntilDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInGracePeriodUntilDateTime() {
        return Optional.ofNullable(inGracePeriodUntilDateTime);
    }

    public ManagedDeviceCompliance withInGracePeriodUntilDateTime(OffsetDateTime inGracePeriodUntilDateTime) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("inGracePeriodUntilDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.inGracePeriodUntilDateTime = inGracePeriodUntilDateTime;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public ManagedDeviceCompliance withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    public ManagedDeviceCompliance withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public ManagedDeviceCompliance withManagedDeviceId(String managedDeviceId) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    public ManagedDeviceCompliance withManagedDeviceName(String managedDeviceName) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public ManagedDeviceCompliance withManufacturer(String manufacturer) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public ManagedDeviceCompliance withModel(String model) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.model = model;
        return _x;
    }

    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    public ManagedDeviceCompliance withOsDescription(String osDescription) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.osDescription = osDescription;
        return _x;
    }

    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    public ManagedDeviceCompliance withOsVersion(String osVersion) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.osVersion = osVersion;
        return _x;
    }

    @Property(name="ownerType")
    @JsonIgnore
    public Optional<String> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    public ManagedDeviceCompliance withOwnerType(String ownerType) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("ownerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.ownerType = ownerType;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public ManagedDeviceCompliance withTenantDisplayName(String tenantDisplayName) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ManagedDeviceCompliance withTenantId(String tenantId) {
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedDeviceCompliance");
        _x.tenantId = tenantId;
        return _x;
    }

    public ManagedDeviceCompliance withUnmappedField(String name, Object value) {
        ManagedDeviceCompliance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceCompliance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceCompliance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceCompliance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceCompliance _copy() {
        ManagedDeviceCompliance _x = new ManagedDeviceCompliance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.complianceStatus = complianceStatus;
        _x.deviceType = deviceType;
        _x.inGracePeriodUntilDateTime = inGracePeriodUntilDateTime;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.osDescription = osDescription;
        _x.osVersion = osVersion;
        _x.ownerType = ownerType;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceCompliance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("complianceStatus=");
        b.append(this.complianceStatus);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("inGracePeriodUntilDateTime=");
        b.append(this.inGracePeriodUntilDateTime);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
