package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "lastRefreshedDateTime", 
    "mfaAndSsprCapableUserCount", 
    "mfaConditionalAccessPolicyState", 
    "mfaRegisteredUserCount", 
    "securityDefaultsEnabled", 
    "ssprEnabledUserCount", 
    "ssprRegisteredUserCount", 
    "tenantDisplayName", 
    "tenantId", 
    "totalUserCount"})
@JsonInclude(Include.NON_NULL)
public class CredentialUserRegistrationsSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.credentialUserRegistrationsSummary";
    }

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("mfaAndSsprCapableUserCount")
    protected Integer mfaAndSsprCapableUserCount;

    @JsonProperty("mfaConditionalAccessPolicyState")
    protected String mfaConditionalAccessPolicyState;

    @JsonProperty("mfaRegisteredUserCount")
    protected Integer mfaRegisteredUserCount;

    @JsonProperty("securityDefaultsEnabled")
    protected Boolean securityDefaultsEnabled;

    @JsonProperty("ssprEnabledUserCount")
    protected Integer ssprEnabledUserCount;

    @JsonProperty("ssprRegisteredUserCount")
    protected Integer ssprRegisteredUserCount;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("totalUserCount")
    protected Integer totalUserCount;

    protected CredentialUserRegistrationsSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCredentialUserRegistrationsSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastRefreshedDateTime;
        private Integer mfaAndSsprCapableUserCount;
        private String mfaConditionalAccessPolicyState;
        private Integer mfaRegisteredUserCount;
        private Boolean securityDefaultsEnabled;
        private Integer ssprEnabledUserCount;
        private Integer ssprRegisteredUserCount;
        private String tenantDisplayName;
        private String tenantId;
        private Integer totalUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder mfaAndSsprCapableUserCount(Integer mfaAndSsprCapableUserCount) {
            this.mfaAndSsprCapableUserCount = mfaAndSsprCapableUserCount;
            this.changedFields = changedFields.add("mfaAndSsprCapableUserCount");
            return this;
        }

        public Builder mfaConditionalAccessPolicyState(String mfaConditionalAccessPolicyState) {
            this.mfaConditionalAccessPolicyState = mfaConditionalAccessPolicyState;
            this.changedFields = changedFields.add("mfaConditionalAccessPolicyState");
            return this;
        }

        public Builder mfaRegisteredUserCount(Integer mfaRegisteredUserCount) {
            this.mfaRegisteredUserCount = mfaRegisteredUserCount;
            this.changedFields = changedFields.add("mfaRegisteredUserCount");
            return this;
        }

        public Builder securityDefaultsEnabled(Boolean securityDefaultsEnabled) {
            this.securityDefaultsEnabled = securityDefaultsEnabled;
            this.changedFields = changedFields.add("securityDefaultsEnabled");
            return this;
        }

        public Builder ssprEnabledUserCount(Integer ssprEnabledUserCount) {
            this.ssprEnabledUserCount = ssprEnabledUserCount;
            this.changedFields = changedFields.add("ssprEnabledUserCount");
            return this;
        }

        public Builder ssprRegisteredUserCount(Integer ssprRegisteredUserCount) {
            this.ssprRegisteredUserCount = ssprRegisteredUserCount;
            this.changedFields = changedFields.add("ssprRegisteredUserCount");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder totalUserCount(Integer totalUserCount) {
            this.totalUserCount = totalUserCount;
            this.changedFields = changedFields.add("totalUserCount");
            return this;
        }

        public CredentialUserRegistrationsSummary build() {
            CredentialUserRegistrationsSummary _x = new CredentialUserRegistrationsSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.credentialUserRegistrationsSummary";
            _x.id = id;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.mfaAndSsprCapableUserCount = mfaAndSsprCapableUserCount;
            _x.mfaConditionalAccessPolicyState = mfaConditionalAccessPolicyState;
            _x.mfaRegisteredUserCount = mfaRegisteredUserCount;
            _x.securityDefaultsEnabled = securityDefaultsEnabled;
            _x.ssprEnabledUserCount = ssprEnabledUserCount;
            _x.ssprRegisteredUserCount = ssprRegisteredUserCount;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            _x.totalUserCount = totalUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public CredentialUserRegistrationsSummary withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="mfaAndSsprCapableUserCount")
    @JsonIgnore
    public Optional<Integer> getMfaAndSsprCapableUserCount() {
        return Optional.ofNullable(mfaAndSsprCapableUserCount);
    }

    public CredentialUserRegistrationsSummary withMfaAndSsprCapableUserCount(Integer mfaAndSsprCapableUserCount) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("mfaAndSsprCapableUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.mfaAndSsprCapableUserCount = mfaAndSsprCapableUserCount;
        return _x;
    }

    @Property(name="mfaConditionalAccessPolicyState")
    @JsonIgnore
    public Optional<String> getMfaConditionalAccessPolicyState() {
        return Optional.ofNullable(mfaConditionalAccessPolicyState);
    }

    public CredentialUserRegistrationsSummary withMfaConditionalAccessPolicyState(String mfaConditionalAccessPolicyState) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("mfaConditionalAccessPolicyState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.mfaConditionalAccessPolicyState = mfaConditionalAccessPolicyState;
        return _x;
    }

    @Property(name="mfaRegisteredUserCount")
    @JsonIgnore
    public Optional<Integer> getMfaRegisteredUserCount() {
        return Optional.ofNullable(mfaRegisteredUserCount);
    }

    public CredentialUserRegistrationsSummary withMfaRegisteredUserCount(Integer mfaRegisteredUserCount) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("mfaRegisteredUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.mfaRegisteredUserCount = mfaRegisteredUserCount;
        return _x;
    }

    @Property(name="securityDefaultsEnabled")
    @JsonIgnore
    public Optional<Boolean> getSecurityDefaultsEnabled() {
        return Optional.ofNullable(securityDefaultsEnabled);
    }

    public CredentialUserRegistrationsSummary withSecurityDefaultsEnabled(Boolean securityDefaultsEnabled) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("securityDefaultsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.securityDefaultsEnabled = securityDefaultsEnabled;
        return _x;
    }

    @Property(name="ssprEnabledUserCount")
    @JsonIgnore
    public Optional<Integer> getSsprEnabledUserCount() {
        return Optional.ofNullable(ssprEnabledUserCount);
    }

    public CredentialUserRegistrationsSummary withSsprEnabledUserCount(Integer ssprEnabledUserCount) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("ssprEnabledUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.ssprEnabledUserCount = ssprEnabledUserCount;
        return _x;
    }

    @Property(name="ssprRegisteredUserCount")
    @JsonIgnore
    public Optional<Integer> getSsprRegisteredUserCount() {
        return Optional.ofNullable(ssprRegisteredUserCount);
    }

    public CredentialUserRegistrationsSummary withSsprRegisteredUserCount(Integer ssprRegisteredUserCount) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("ssprRegisteredUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.ssprRegisteredUserCount = ssprRegisteredUserCount;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public CredentialUserRegistrationsSummary withTenantDisplayName(String tenantDisplayName) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public CredentialUserRegistrationsSummary withTenantId(String tenantId) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="totalUserCount")
    @JsonIgnore
    public Optional<Integer> getTotalUserCount() {
        return Optional.ofNullable(totalUserCount);
    }

    public CredentialUserRegistrationsSummary withTotalUserCount(Integer totalUserCount) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = changedFields.add("totalUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.credentialUserRegistrationsSummary");
        _x.totalUserCount = totalUserCount;
        return _x;
    }

    public CredentialUserRegistrationsSummary withUnmappedField(String name, Object value) {
        CredentialUserRegistrationsSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationsSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationsSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationsSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CredentialUserRegistrationsSummary _copy() {
        CredentialUserRegistrationsSummary _x = new CredentialUserRegistrationsSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.mfaAndSsprCapableUserCount = mfaAndSsprCapableUserCount;
        _x.mfaConditionalAccessPolicyState = mfaConditionalAccessPolicyState;
        _x.mfaRegisteredUserCount = mfaRegisteredUserCount;
        _x.securityDefaultsEnabled = securityDefaultsEnabled;
        _x.ssprEnabledUserCount = ssprEnabledUserCount;
        _x.ssprRegisteredUserCount = ssprRegisteredUserCount;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        _x.totalUserCount = totalUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CredentialUserRegistrationsSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("mfaAndSsprCapableUserCount=");
        b.append(this.mfaAndSsprCapableUserCount);
        b.append(", ");
        b.append("mfaConditionalAccessPolicyState=");
        b.append(this.mfaConditionalAccessPolicyState);
        b.append(", ");
        b.append("mfaRegisteredUserCount=");
        b.append(this.mfaRegisteredUserCount);
        b.append(", ");
        b.append("securityDefaultsEnabled=");
        b.append(this.securityDefaultsEnabled);
        b.append(", ");
        b.append("ssprEnabledUserCount=");
        b.append(this.ssprEnabledUserCount);
        b.append(", ");
        b.append("ssprRegisteredUserCount=");
        b.append(this.ssprRegisteredUserCount);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("totalUserCount=");
        b.append(this.totalUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
