package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastRefreshedDateTime", 
    "numberOfCloudPcConnectionStatusFailed", 
    "numberOfCloudPcConnectionStatusPassed", 
    "numberOfCloudPcConnectionStatusPending", 
    "numberOfCloudPcConnectionStatusRunning", 
    "numberOfCloudPcConnectionStatusUnkownFutureValue", 
    "numberOfCloudPcStatusDeprovisioning", 
    "numberOfCloudPcStatusFailed", 
    "numberOfCloudPcStatusInGracePeriod", 
    "numberOfCloudPcStatusNotProvisioned", 
    "numberOfCloudPcStatusProvisioned", 
    "numberOfCloudPcStatusProvisioning", 
    "numberOfCloudPcStatusUnknown", 
    "numberOfCloudPcStatusUpgrading", 
    "tenantDisplayName", 
    "tenantId", 
    "totalCloudPcConnectionStatus", 
    "totalCloudPcStatus"})
@JsonInclude(Include.NON_NULL)
public class CloudPcOverview implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.cloudPcOverview";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("numberOfCloudPcConnectionStatusFailed")
    protected Integer numberOfCloudPcConnectionStatusFailed;

    @JsonProperty("numberOfCloudPcConnectionStatusPassed")
    protected Integer numberOfCloudPcConnectionStatusPassed;

    @JsonProperty("numberOfCloudPcConnectionStatusPending")
    protected Integer numberOfCloudPcConnectionStatusPending;

    @JsonProperty("numberOfCloudPcConnectionStatusRunning")
    protected Integer numberOfCloudPcConnectionStatusRunning;

    @JsonProperty("numberOfCloudPcConnectionStatusUnkownFutureValue")
    protected Integer numberOfCloudPcConnectionStatusUnkownFutureValue;

    @JsonProperty("numberOfCloudPcStatusDeprovisioning")
    protected Integer numberOfCloudPcStatusDeprovisioning;

    @JsonProperty("numberOfCloudPcStatusFailed")
    protected Integer numberOfCloudPcStatusFailed;

    @JsonProperty("numberOfCloudPcStatusInGracePeriod")
    protected Integer numberOfCloudPcStatusInGracePeriod;

    @JsonProperty("numberOfCloudPcStatusNotProvisioned")
    protected Integer numberOfCloudPcStatusNotProvisioned;

    @JsonProperty("numberOfCloudPcStatusProvisioned")
    protected Integer numberOfCloudPcStatusProvisioned;

    @JsonProperty("numberOfCloudPcStatusProvisioning")
    protected Integer numberOfCloudPcStatusProvisioning;

    @JsonProperty("numberOfCloudPcStatusUnknown")
    protected Integer numberOfCloudPcStatusUnknown;

    @JsonProperty("numberOfCloudPcStatusUpgrading")
    protected Integer numberOfCloudPcStatusUpgrading;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("totalCloudPcConnectionStatus")
    protected Integer totalCloudPcConnectionStatus;

    @JsonProperty("totalCloudPcStatus")
    protected Integer totalCloudPcStatus;

    protected CloudPcOverview() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastRefreshedDateTime;
        private Integer numberOfCloudPcConnectionStatusFailed;
        private Integer numberOfCloudPcConnectionStatusPassed;
        private Integer numberOfCloudPcConnectionStatusPending;
        private Integer numberOfCloudPcConnectionStatusRunning;
        private Integer numberOfCloudPcConnectionStatusUnkownFutureValue;
        private Integer numberOfCloudPcStatusDeprovisioning;
        private Integer numberOfCloudPcStatusFailed;
        private Integer numberOfCloudPcStatusInGracePeriod;
        private Integer numberOfCloudPcStatusNotProvisioned;
        private Integer numberOfCloudPcStatusProvisioned;
        private Integer numberOfCloudPcStatusProvisioning;
        private Integer numberOfCloudPcStatusUnknown;
        private Integer numberOfCloudPcStatusUpgrading;
        private String tenantDisplayName;
        private String tenantId;
        private Integer totalCloudPcConnectionStatus;
        private Integer totalCloudPcStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder numberOfCloudPcConnectionStatusFailed(Integer numberOfCloudPcConnectionStatusFailed) {
            this.numberOfCloudPcConnectionStatusFailed = numberOfCloudPcConnectionStatusFailed;
            this.changedFields = changedFields.add("numberOfCloudPcConnectionStatusFailed");
            return this;
        }

        public Builder numberOfCloudPcConnectionStatusPassed(Integer numberOfCloudPcConnectionStatusPassed) {
            this.numberOfCloudPcConnectionStatusPassed = numberOfCloudPcConnectionStatusPassed;
            this.changedFields = changedFields.add("numberOfCloudPcConnectionStatusPassed");
            return this;
        }

        public Builder numberOfCloudPcConnectionStatusPending(Integer numberOfCloudPcConnectionStatusPending) {
            this.numberOfCloudPcConnectionStatusPending = numberOfCloudPcConnectionStatusPending;
            this.changedFields = changedFields.add("numberOfCloudPcConnectionStatusPending");
            return this;
        }

        public Builder numberOfCloudPcConnectionStatusRunning(Integer numberOfCloudPcConnectionStatusRunning) {
            this.numberOfCloudPcConnectionStatusRunning = numberOfCloudPcConnectionStatusRunning;
            this.changedFields = changedFields.add("numberOfCloudPcConnectionStatusRunning");
            return this;
        }

        public Builder numberOfCloudPcConnectionStatusUnkownFutureValue(Integer numberOfCloudPcConnectionStatusUnkownFutureValue) {
            this.numberOfCloudPcConnectionStatusUnkownFutureValue = numberOfCloudPcConnectionStatusUnkownFutureValue;
            this.changedFields = changedFields.add("numberOfCloudPcConnectionStatusUnkownFutureValue");
            return this;
        }

        public Builder numberOfCloudPcStatusDeprovisioning(Integer numberOfCloudPcStatusDeprovisioning) {
            this.numberOfCloudPcStatusDeprovisioning = numberOfCloudPcStatusDeprovisioning;
            this.changedFields = changedFields.add("numberOfCloudPcStatusDeprovisioning");
            return this;
        }

        public Builder numberOfCloudPcStatusFailed(Integer numberOfCloudPcStatusFailed) {
            this.numberOfCloudPcStatusFailed = numberOfCloudPcStatusFailed;
            this.changedFields = changedFields.add("numberOfCloudPcStatusFailed");
            return this;
        }

        public Builder numberOfCloudPcStatusInGracePeriod(Integer numberOfCloudPcStatusInGracePeriod) {
            this.numberOfCloudPcStatusInGracePeriod = numberOfCloudPcStatusInGracePeriod;
            this.changedFields = changedFields.add("numberOfCloudPcStatusInGracePeriod");
            return this;
        }

        public Builder numberOfCloudPcStatusNotProvisioned(Integer numberOfCloudPcStatusNotProvisioned) {
            this.numberOfCloudPcStatusNotProvisioned = numberOfCloudPcStatusNotProvisioned;
            this.changedFields = changedFields.add("numberOfCloudPcStatusNotProvisioned");
            return this;
        }

        public Builder numberOfCloudPcStatusProvisioned(Integer numberOfCloudPcStatusProvisioned) {
            this.numberOfCloudPcStatusProvisioned = numberOfCloudPcStatusProvisioned;
            this.changedFields = changedFields.add("numberOfCloudPcStatusProvisioned");
            return this;
        }

        public Builder numberOfCloudPcStatusProvisioning(Integer numberOfCloudPcStatusProvisioning) {
            this.numberOfCloudPcStatusProvisioning = numberOfCloudPcStatusProvisioning;
            this.changedFields = changedFields.add("numberOfCloudPcStatusProvisioning");
            return this;
        }

        public Builder numberOfCloudPcStatusUnknown(Integer numberOfCloudPcStatusUnknown) {
            this.numberOfCloudPcStatusUnknown = numberOfCloudPcStatusUnknown;
            this.changedFields = changedFields.add("numberOfCloudPcStatusUnknown");
            return this;
        }

        public Builder numberOfCloudPcStatusUpgrading(Integer numberOfCloudPcStatusUpgrading) {
            this.numberOfCloudPcStatusUpgrading = numberOfCloudPcStatusUpgrading;
            this.changedFields = changedFields.add("numberOfCloudPcStatusUpgrading");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder totalCloudPcConnectionStatus(Integer totalCloudPcConnectionStatus) {
            this.totalCloudPcConnectionStatus = totalCloudPcConnectionStatus;
            this.changedFields = changedFields.add("totalCloudPcConnectionStatus");
            return this;
        }

        public Builder totalCloudPcStatus(Integer totalCloudPcStatus) {
            this.totalCloudPcStatus = totalCloudPcStatus;
            this.changedFields = changedFields.add("totalCloudPcStatus");
            return this;
        }

        public CloudPcOverview build() {
            CloudPcOverview _x = new CloudPcOverview();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.cloudPcOverview";
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.numberOfCloudPcConnectionStatusFailed = numberOfCloudPcConnectionStatusFailed;
            _x.numberOfCloudPcConnectionStatusPassed = numberOfCloudPcConnectionStatusPassed;
            _x.numberOfCloudPcConnectionStatusPending = numberOfCloudPcConnectionStatusPending;
            _x.numberOfCloudPcConnectionStatusRunning = numberOfCloudPcConnectionStatusRunning;
            _x.numberOfCloudPcConnectionStatusUnkownFutureValue = numberOfCloudPcConnectionStatusUnkownFutureValue;
            _x.numberOfCloudPcStatusDeprovisioning = numberOfCloudPcStatusDeprovisioning;
            _x.numberOfCloudPcStatusFailed = numberOfCloudPcStatusFailed;
            _x.numberOfCloudPcStatusInGracePeriod = numberOfCloudPcStatusInGracePeriod;
            _x.numberOfCloudPcStatusNotProvisioned = numberOfCloudPcStatusNotProvisioned;
            _x.numberOfCloudPcStatusProvisioned = numberOfCloudPcStatusProvisioned;
            _x.numberOfCloudPcStatusProvisioning = numberOfCloudPcStatusProvisioning;
            _x.numberOfCloudPcStatusUnknown = numberOfCloudPcStatusUnknown;
            _x.numberOfCloudPcStatusUpgrading = numberOfCloudPcStatusUpgrading;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            _x.totalCloudPcConnectionStatus = totalCloudPcConnectionStatus;
            _x.totalCloudPcStatus = totalCloudPcStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && tenantId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(tenantId, String.class));
        }
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public CloudPcOverview withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="numberOfCloudPcConnectionStatusFailed")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcConnectionStatusFailed() {
        return Optional.ofNullable(numberOfCloudPcConnectionStatusFailed);
    }

    public CloudPcOverview withNumberOfCloudPcConnectionStatusFailed(Integer numberOfCloudPcConnectionStatusFailed) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcConnectionStatusFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcConnectionStatusFailed = numberOfCloudPcConnectionStatusFailed;
        return _x;
    }

    @Property(name="numberOfCloudPcConnectionStatusPassed")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcConnectionStatusPassed() {
        return Optional.ofNullable(numberOfCloudPcConnectionStatusPassed);
    }

    public CloudPcOverview withNumberOfCloudPcConnectionStatusPassed(Integer numberOfCloudPcConnectionStatusPassed) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcConnectionStatusPassed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcConnectionStatusPassed = numberOfCloudPcConnectionStatusPassed;
        return _x;
    }

    @Property(name="numberOfCloudPcConnectionStatusPending")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcConnectionStatusPending() {
        return Optional.ofNullable(numberOfCloudPcConnectionStatusPending);
    }

    public CloudPcOverview withNumberOfCloudPcConnectionStatusPending(Integer numberOfCloudPcConnectionStatusPending) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcConnectionStatusPending");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcConnectionStatusPending = numberOfCloudPcConnectionStatusPending;
        return _x;
    }

    @Property(name="numberOfCloudPcConnectionStatusRunning")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcConnectionStatusRunning() {
        return Optional.ofNullable(numberOfCloudPcConnectionStatusRunning);
    }

    public CloudPcOverview withNumberOfCloudPcConnectionStatusRunning(Integer numberOfCloudPcConnectionStatusRunning) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcConnectionStatusRunning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcConnectionStatusRunning = numberOfCloudPcConnectionStatusRunning;
        return _x;
    }

    @Property(name="numberOfCloudPcConnectionStatusUnkownFutureValue")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcConnectionStatusUnkownFutureValue() {
        return Optional.ofNullable(numberOfCloudPcConnectionStatusUnkownFutureValue);
    }

    public CloudPcOverview withNumberOfCloudPcConnectionStatusUnkownFutureValue(Integer numberOfCloudPcConnectionStatusUnkownFutureValue) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcConnectionStatusUnkownFutureValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcConnectionStatusUnkownFutureValue = numberOfCloudPcConnectionStatusUnkownFutureValue;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusDeprovisioning")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusDeprovisioning() {
        return Optional.ofNullable(numberOfCloudPcStatusDeprovisioning);
    }

    public CloudPcOverview withNumberOfCloudPcStatusDeprovisioning(Integer numberOfCloudPcStatusDeprovisioning) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusDeprovisioning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusDeprovisioning = numberOfCloudPcStatusDeprovisioning;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusFailed")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusFailed() {
        return Optional.ofNullable(numberOfCloudPcStatusFailed);
    }

    public CloudPcOverview withNumberOfCloudPcStatusFailed(Integer numberOfCloudPcStatusFailed) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusFailed = numberOfCloudPcStatusFailed;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusInGracePeriod")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusInGracePeriod() {
        return Optional.ofNullable(numberOfCloudPcStatusInGracePeriod);
    }

    public CloudPcOverview withNumberOfCloudPcStatusInGracePeriod(Integer numberOfCloudPcStatusInGracePeriod) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusInGracePeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusInGracePeriod = numberOfCloudPcStatusInGracePeriod;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusNotProvisioned")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusNotProvisioned() {
        return Optional.ofNullable(numberOfCloudPcStatusNotProvisioned);
    }

    public CloudPcOverview withNumberOfCloudPcStatusNotProvisioned(Integer numberOfCloudPcStatusNotProvisioned) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusNotProvisioned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusNotProvisioned = numberOfCloudPcStatusNotProvisioned;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusProvisioned")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusProvisioned() {
        return Optional.ofNullable(numberOfCloudPcStatusProvisioned);
    }

    public CloudPcOverview withNumberOfCloudPcStatusProvisioned(Integer numberOfCloudPcStatusProvisioned) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusProvisioned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusProvisioned = numberOfCloudPcStatusProvisioned;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusProvisioning")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusProvisioning() {
        return Optional.ofNullable(numberOfCloudPcStatusProvisioning);
    }

    public CloudPcOverview withNumberOfCloudPcStatusProvisioning(Integer numberOfCloudPcStatusProvisioning) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusProvisioning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusProvisioning = numberOfCloudPcStatusProvisioning;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusUnknown")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusUnknown() {
        return Optional.ofNullable(numberOfCloudPcStatusUnknown);
    }

    public CloudPcOverview withNumberOfCloudPcStatusUnknown(Integer numberOfCloudPcStatusUnknown) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusUnknown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusUnknown = numberOfCloudPcStatusUnknown;
        return _x;
    }

    @Property(name="numberOfCloudPcStatusUpgrading")
    @JsonIgnore
    public Optional<Integer> getNumberOfCloudPcStatusUpgrading() {
        return Optional.ofNullable(numberOfCloudPcStatusUpgrading);
    }

    public CloudPcOverview withNumberOfCloudPcStatusUpgrading(Integer numberOfCloudPcStatusUpgrading) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("numberOfCloudPcStatusUpgrading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.numberOfCloudPcStatusUpgrading = numberOfCloudPcStatusUpgrading;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public CloudPcOverview withTenantDisplayName(String tenantDisplayName) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public CloudPcOverview withTenantId(String tenantId) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="totalCloudPcConnectionStatus")
    @JsonIgnore
    public Optional<Integer> getTotalCloudPcConnectionStatus() {
        return Optional.ofNullable(totalCloudPcConnectionStatus);
    }

    public CloudPcOverview withTotalCloudPcConnectionStatus(Integer totalCloudPcConnectionStatus) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("totalCloudPcConnectionStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.totalCloudPcConnectionStatus = totalCloudPcConnectionStatus;
        return _x;
    }

    @Property(name="totalCloudPcStatus")
    @JsonIgnore
    public Optional<Integer> getTotalCloudPcStatus() {
        return Optional.ofNullable(totalCloudPcStatus);
    }

    public CloudPcOverview withTotalCloudPcStatus(Integer totalCloudPcStatus) {
        CloudPcOverview _x = _copy();
        _x.changedFields = changedFields.add("totalCloudPcStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcOverview");
        _x.totalCloudPcStatus = totalCloudPcStatus;
        return _x;
    }

    public CloudPcOverview withUnmappedField(String name, Object value) {
        CloudPcOverview _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOverview patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcOverview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOverview put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcOverview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcOverview _copy() {
        CloudPcOverview _x = new CloudPcOverview();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.numberOfCloudPcConnectionStatusFailed = numberOfCloudPcConnectionStatusFailed;
        _x.numberOfCloudPcConnectionStatusPassed = numberOfCloudPcConnectionStatusPassed;
        _x.numberOfCloudPcConnectionStatusPending = numberOfCloudPcConnectionStatusPending;
        _x.numberOfCloudPcConnectionStatusRunning = numberOfCloudPcConnectionStatusRunning;
        _x.numberOfCloudPcConnectionStatusUnkownFutureValue = numberOfCloudPcConnectionStatusUnkownFutureValue;
        _x.numberOfCloudPcStatusDeprovisioning = numberOfCloudPcStatusDeprovisioning;
        _x.numberOfCloudPcStatusFailed = numberOfCloudPcStatusFailed;
        _x.numberOfCloudPcStatusInGracePeriod = numberOfCloudPcStatusInGracePeriod;
        _x.numberOfCloudPcStatusNotProvisioned = numberOfCloudPcStatusNotProvisioned;
        _x.numberOfCloudPcStatusProvisioned = numberOfCloudPcStatusProvisioned;
        _x.numberOfCloudPcStatusProvisioning = numberOfCloudPcStatusProvisioning;
        _x.numberOfCloudPcStatusUnknown = numberOfCloudPcStatusUnknown;
        _x.numberOfCloudPcStatusUpgrading = numberOfCloudPcStatusUpgrading;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        _x.totalCloudPcConnectionStatus = totalCloudPcConnectionStatus;
        _x.totalCloudPcStatus = totalCloudPcStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcOverview[");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("numberOfCloudPcConnectionStatusFailed=");
        b.append(this.numberOfCloudPcConnectionStatusFailed);
        b.append(", ");
        b.append("numberOfCloudPcConnectionStatusPassed=");
        b.append(this.numberOfCloudPcConnectionStatusPassed);
        b.append(", ");
        b.append("numberOfCloudPcConnectionStatusPending=");
        b.append(this.numberOfCloudPcConnectionStatusPending);
        b.append(", ");
        b.append("numberOfCloudPcConnectionStatusRunning=");
        b.append(this.numberOfCloudPcConnectionStatusRunning);
        b.append(", ");
        b.append("numberOfCloudPcConnectionStatusUnkownFutureValue=");
        b.append(this.numberOfCloudPcConnectionStatusUnkownFutureValue);
        b.append(", ");
        b.append("numberOfCloudPcStatusDeprovisioning=");
        b.append(this.numberOfCloudPcStatusDeprovisioning);
        b.append(", ");
        b.append("numberOfCloudPcStatusFailed=");
        b.append(this.numberOfCloudPcStatusFailed);
        b.append(", ");
        b.append("numberOfCloudPcStatusInGracePeriod=");
        b.append(this.numberOfCloudPcStatusInGracePeriod);
        b.append(", ");
        b.append("numberOfCloudPcStatusNotProvisioned=");
        b.append(this.numberOfCloudPcStatusNotProvisioned);
        b.append(", ");
        b.append("numberOfCloudPcStatusProvisioned=");
        b.append(this.numberOfCloudPcStatusProvisioned);
        b.append(", ");
        b.append("numberOfCloudPcStatusProvisioning=");
        b.append(this.numberOfCloudPcStatusProvisioning);
        b.append(", ");
        b.append("numberOfCloudPcStatusUnknown=");
        b.append(this.numberOfCloudPcStatusUnknown);
        b.append(", ");
        b.append("numberOfCloudPcStatusUpgrading=");
        b.append(this.numberOfCloudPcStatusUpgrading);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("totalCloudPcConnectionStatus=");
        b.append(this.totalCloudPcConnectionStatus);
        b.append(", ");
        b.append("totalCloudPcStatus=");
        b.append(this.totalCloudPcStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
