package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "healthCheckStatus", 
    "lastRefreshedDateTime", 
    "tenantDisplayName", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class CloudPcConnection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.cloudPcConnection";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("healthCheckStatus")
    protected String healthCheckStatus;

    @JsonProperty("lastRefreshedDateTime")
    protected OffsetDateTime lastRefreshedDateTime;

    @JsonProperty("tenantDisplayName")
    protected String tenantDisplayName;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected CloudPcConnection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcConnection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String healthCheckStatus;
        private OffsetDateTime lastRefreshedDateTime;
        private String tenantDisplayName;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder healthCheckStatus(String healthCheckStatus) {
            this.healthCheckStatus = healthCheckStatus;
            this.changedFields = changedFields.add("healthCheckStatus");
            return this;
        }

        public Builder lastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
            this.lastRefreshedDateTime = lastRefreshedDateTime;
            this.changedFields = changedFields.add("lastRefreshedDateTime");
            return this;
        }

        public Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            this.changedFields = changedFields.add("tenantDisplayName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public CloudPcConnection build() {
            CloudPcConnection _x = new CloudPcConnection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.cloudPcConnection";
            _x.id = id;
            _x.displayName = displayName;
            _x.healthCheckStatus = healthCheckStatus;
            _x.lastRefreshedDateTime = lastRefreshedDateTime;
            _x.tenantDisplayName = tenantDisplayName;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcConnection withDisplayName(String displayName) {
        CloudPcConnection _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcConnection");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="healthCheckStatus")
    @JsonIgnore
    public Optional<String> getHealthCheckStatus() {
        return Optional.ofNullable(healthCheckStatus);
    }

    public CloudPcConnection withHealthCheckStatus(String healthCheckStatus) {
        CloudPcConnection _x = _copy();
        _x.changedFields = changedFields.add("healthCheckStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcConnection");
        _x.healthCheckStatus = healthCheckStatus;
        return _x;
    }

    @Property(name="lastRefreshedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRefreshedDateTime() {
        return Optional.ofNullable(lastRefreshedDateTime);
    }

    public CloudPcConnection withLastRefreshedDateTime(OffsetDateTime lastRefreshedDateTime) {
        CloudPcConnection _x = _copy();
        _x.changedFields = changedFields.add("lastRefreshedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcConnection");
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        return _x;
    }

    @Property(name="tenantDisplayName")
    @JsonIgnore
    public Optional<String> getTenantDisplayName() {
        return Optional.ofNullable(tenantDisplayName);
    }

    public CloudPcConnection withTenantDisplayName(String tenantDisplayName) {
        CloudPcConnection _x = _copy();
        _x.changedFields = changedFields.add("tenantDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcConnection");
        _x.tenantDisplayName = tenantDisplayName;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public CloudPcConnection withTenantId(String tenantId) {
        CloudPcConnection _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.cloudPcConnection");
        _x.tenantId = tenantId;
        return _x;
    }

    public CloudPcConnection withUnmappedField(String name, Object value) {
        CloudPcConnection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcConnection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcConnection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcConnection _copy() {
        CloudPcConnection _x = new CloudPcConnection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.healthCheckStatus = healthCheckStatus;
        _x.lastRefreshedDateTime = lastRefreshedDateTime;
        _x.tenantDisplayName = tenantDisplayName;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcConnection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("healthCheckStatus=");
        b.append(this.healthCheckStatus);
        b.append(", ");
        b.append("lastRefreshedDateTime=");
        b.append(this.lastRefreshedDateTime);
        b.append(", ");
        b.append("tenantDisplayName=");
        b.append(this.tenantDisplayName);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
