package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "activityDateTime", 
    "activityId", 
    "category", 
    "httpVerb", 
    "initiatedByAppId", 
    "initiatedByUpn", 
    "initiatedByUserId", 
    "ipAddress", 
    "requestBody", 
    "requestUrl", 
    "tenantIds", 
    "tenantNames"})
@JsonInclude(Include.NON_NULL)
public class AuditEvent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.auditEvent";
    }

    @JsonProperty("activity")
    protected String activity;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("activityId")
    protected String activityId;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("httpVerb")
    protected String httpVerb;

    @JsonProperty("initiatedByAppId")
    protected String initiatedByAppId;

    @JsonProperty("initiatedByUpn")
    protected String initiatedByUpn;

    @JsonProperty("initiatedByUserId")
    protected String initiatedByUserId;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("requestBody")
    protected String requestBody;

    @JsonProperty("requestUrl")
    protected String requestUrl;

    @JsonProperty("tenantIds")
    protected String tenantIds;

    @JsonProperty("tenantNames")
    protected String tenantNames;

    protected AuditEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuditEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String activity;
        private OffsetDateTime activityDateTime;
        private String activityId;
        private String category;
        private String httpVerb;
        private String initiatedByAppId;
        private String initiatedByUpn;
        private String initiatedByUserId;
        private String ipAddress;
        private String requestBody;
        private String requestUrl;
        private String tenantIds;
        private String tenantNames;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activity(String activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            this.changedFields = changedFields.add("activityId");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder httpVerb(String httpVerb) {
            this.httpVerb = httpVerb;
            this.changedFields = changedFields.add("httpVerb");
            return this;
        }

        public Builder initiatedByAppId(String initiatedByAppId) {
            this.initiatedByAppId = initiatedByAppId;
            this.changedFields = changedFields.add("initiatedByAppId");
            return this;
        }

        public Builder initiatedByUpn(String initiatedByUpn) {
            this.initiatedByUpn = initiatedByUpn;
            this.changedFields = changedFields.add("initiatedByUpn");
            return this;
        }

        public Builder initiatedByUserId(String initiatedByUserId) {
            this.initiatedByUserId = initiatedByUserId;
            this.changedFields = changedFields.add("initiatedByUserId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder requestBody(String requestBody) {
            this.requestBody = requestBody;
            this.changedFields = changedFields.add("requestBody");
            return this;
        }

        public Builder requestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            this.changedFields = changedFields.add("requestUrl");
            return this;
        }

        public Builder tenantIds(String tenantIds) {
            this.tenantIds = tenantIds;
            this.changedFields = changedFields.add("tenantIds");
            return this;
        }

        public Builder tenantNames(String tenantNames) {
            this.tenantNames = tenantNames;
            this.changedFields = changedFields.add("tenantNames");
            return this;
        }

        public AuditEvent build() {
            AuditEvent _x = new AuditEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.auditEvent";
            _x.id = id;
            _x.activity = activity;
            _x.activityDateTime = activityDateTime;
            _x.activityId = activityId;
            _x.category = category;
            _x.httpVerb = httpVerb;
            _x.initiatedByAppId = initiatedByAppId;
            _x.initiatedByUpn = initiatedByUpn;
            _x.initiatedByUserId = initiatedByUserId;
            _x.ipAddress = ipAddress;
            _x.requestBody = requestBody;
            _x.requestUrl = requestUrl;
            _x.tenantIds = tenantIds;
            _x.tenantNames = tenantNames;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<String> getActivity() {
        return Optional.ofNullable(activity);
    }

    public AuditEvent withActivity(String activity) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.activity = activity;
        return _x;
    }

    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    public AuditEvent withActivityDateTime(OffsetDateTime activityDateTime) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    @Property(name="activityId")
    @JsonIgnore
    public Optional<String> getActivityId() {
        return Optional.ofNullable(activityId);
    }

    public AuditEvent withActivityId(String activityId) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.activityId = activityId;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public AuditEvent withCategory(String category) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.category = category;
        return _x;
    }

    @Property(name="httpVerb")
    @JsonIgnore
    public Optional<String> getHttpVerb() {
        return Optional.ofNullable(httpVerb);
    }

    public AuditEvent withHttpVerb(String httpVerb) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("httpVerb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.httpVerb = httpVerb;
        return _x;
    }

    @Property(name="initiatedByAppId")
    @JsonIgnore
    public Optional<String> getInitiatedByAppId() {
        return Optional.ofNullable(initiatedByAppId);
    }

    public AuditEvent withInitiatedByAppId(String initiatedByAppId) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("initiatedByAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.initiatedByAppId = initiatedByAppId;
        return _x;
    }

    @Property(name="initiatedByUpn")
    @JsonIgnore
    public Optional<String> getInitiatedByUpn() {
        return Optional.ofNullable(initiatedByUpn);
    }

    public AuditEvent withInitiatedByUpn(String initiatedByUpn) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("initiatedByUpn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.initiatedByUpn = initiatedByUpn;
        return _x;
    }

    @Property(name="initiatedByUserId")
    @JsonIgnore
    public Optional<String> getInitiatedByUserId() {
        return Optional.ofNullable(initiatedByUserId);
    }

    public AuditEvent withInitiatedByUserId(String initiatedByUserId) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("initiatedByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.initiatedByUserId = initiatedByUserId;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public AuditEvent withIpAddress(String ipAddress) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("ipAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="requestBody")
    @JsonIgnore
    public Optional<String> getRequestBody() {
        return Optional.ofNullable(requestBody);
    }

    public AuditEvent withRequestBody(String requestBody) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("requestBody");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.requestBody = requestBody;
        return _x;
    }

    @Property(name="requestUrl")
    @JsonIgnore
    public Optional<String> getRequestUrl() {
        return Optional.ofNullable(requestUrl);
    }

    public AuditEvent withRequestUrl(String requestUrl) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("requestUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.requestUrl = requestUrl;
        return _x;
    }

    @Property(name="tenantIds")
    @JsonIgnore
    public Optional<String> getTenantIds() {
        return Optional.ofNullable(tenantIds);
    }

    public AuditEvent withTenantIds(String tenantIds) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("tenantIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.tenantIds = tenantIds;
        return _x;
    }

    @Property(name="tenantNames")
    @JsonIgnore
    public Optional<String> getTenantNames() {
        return Optional.ofNullable(tenantNames);
    }

    public AuditEvent withTenantNames(String tenantNames) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("tenantNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.auditEvent");
        _x.tenantNames = tenantNames;
        return _x;
    }

    public AuditEvent withUnmappedField(String name, Object value) {
        AuditEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuditEvent _copy() {
        AuditEvent _x = new AuditEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.activityDateTime = activityDateTime;
        _x.activityId = activityId;
        _x.category = category;
        _x.httpVerb = httpVerb;
        _x.initiatedByAppId = initiatedByAppId;
        _x.initiatedByUpn = initiatedByUpn;
        _x.initiatedByUserId = initiatedByUserId;
        _x.ipAddress = ipAddress;
        _x.requestBody = requestBody;
        _x.requestUrl = requestUrl;
        _x.tenantIds = tenantIds;
        _x.tenantNames = tenantNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("activityId=");
        b.append(this.activityId);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("httpVerb=");
        b.append(this.httpVerb);
        b.append(", ");
        b.append("initiatedByAppId=");
        b.append(this.initiatedByAppId);
        b.append(", ");
        b.append("initiatedByUpn=");
        b.append(this.initiatedByUpn);
        b.append(", ");
        b.append("initiatedByUserId=");
        b.append(this.initiatedByUserId);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("requestBody=");
        b.append(this.requestBody);
        b.append(", ");
        b.append("requestUrl=");
        b.append(this.requestUrl);
        b.append(", ");
        b.append("tenantIds=");
        b.append(this.tenantIds);
        b.append(", ");
        b.append("tenantNames=");
        b.append(this.tenantNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
