package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.DelegatedPrivilegeStatus;
import odata.msgraph.client.beta.managed.tenants.enums.TenantOnboardingEligibilityReason;
import odata.msgraph.client.beta.managed.tenants.enums.TenantOnboardingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "delegatedPrivilegeStatus", 
    "lastDelegatedPrivilegeRefreshDateTime", 
    "offboardedByUserId", 
    "offboardedDateTime", 
    "onboardedByUserId", 
    "onboardedDateTime", 
    "onboardingStatus", 
    "tenantOnboardingEligibilityReason", 
    "workloadStatuses"})
@JsonInclude(Include.NON_NULL)
public class TenantStatusInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("delegatedPrivilegeStatus")
    protected DelegatedPrivilegeStatus delegatedPrivilegeStatus;

    @JsonProperty("lastDelegatedPrivilegeRefreshDateTime")
    protected OffsetDateTime lastDelegatedPrivilegeRefreshDateTime;

    @JsonProperty("offboardedByUserId")
    protected String offboardedByUserId;

    @JsonProperty("offboardedDateTime")
    protected OffsetDateTime offboardedDateTime;

    @JsonProperty("onboardedByUserId")
    protected String onboardedByUserId;

    @JsonProperty("onboardedDateTime")
    protected OffsetDateTime onboardedDateTime;

    @JsonProperty("onboardingStatus")
    protected TenantOnboardingStatus onboardingStatus;

    @JsonProperty("tenantOnboardingEligibilityReason")
    protected TenantOnboardingEligibilityReason tenantOnboardingEligibilityReason;

    @JsonProperty("workloadStatuses")
    protected List<WorkloadStatus> workloadStatuses;

    @JsonProperty("workloadStatuses@nextLink")
    protected String workloadStatusesNextLink;

    protected TenantStatusInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantStatusInformation";
    }

    @Property(name="delegatedPrivilegeStatus")
    @JsonIgnore
    public Optional<DelegatedPrivilegeStatus> getDelegatedPrivilegeStatus() {
        return Optional.ofNullable(delegatedPrivilegeStatus);
    }

    public TenantStatusInformation withDelegatedPrivilegeStatus(DelegatedPrivilegeStatus delegatedPrivilegeStatus) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.delegatedPrivilegeStatus = delegatedPrivilegeStatus;
        return _x;
    }

    @Property(name="lastDelegatedPrivilegeRefreshDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDelegatedPrivilegeRefreshDateTime() {
        return Optional.ofNullable(lastDelegatedPrivilegeRefreshDateTime);
    }

    public TenantStatusInformation withLastDelegatedPrivilegeRefreshDateTime(OffsetDateTime lastDelegatedPrivilegeRefreshDateTime) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.lastDelegatedPrivilegeRefreshDateTime = lastDelegatedPrivilegeRefreshDateTime;
        return _x;
    }

    @Property(name="offboardedByUserId")
    @JsonIgnore
    public Optional<String> getOffboardedByUserId() {
        return Optional.ofNullable(offboardedByUserId);
    }

    public TenantStatusInformation withOffboardedByUserId(String offboardedByUserId) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.offboardedByUserId = offboardedByUserId;
        return _x;
    }

    @Property(name="offboardedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOffboardedDateTime() {
        return Optional.ofNullable(offboardedDateTime);
    }

    public TenantStatusInformation withOffboardedDateTime(OffsetDateTime offboardedDateTime) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.offboardedDateTime = offboardedDateTime;
        return _x;
    }

    @Property(name="onboardedByUserId")
    @JsonIgnore
    public Optional<String> getOnboardedByUserId() {
        return Optional.ofNullable(onboardedByUserId);
    }

    public TenantStatusInformation withOnboardedByUserId(String onboardedByUserId) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.onboardedByUserId = onboardedByUserId;
        return _x;
    }

    @Property(name="onboardedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnboardedDateTime() {
        return Optional.ofNullable(onboardedDateTime);
    }

    public TenantStatusInformation withOnboardedDateTime(OffsetDateTime onboardedDateTime) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.onboardedDateTime = onboardedDateTime;
        return _x;
    }

    @Property(name="onboardingStatus")
    @JsonIgnore
    public Optional<TenantOnboardingStatus> getOnboardingStatus() {
        return Optional.ofNullable(onboardingStatus);
    }

    public TenantStatusInformation withOnboardingStatus(TenantOnboardingStatus onboardingStatus) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.onboardingStatus = onboardingStatus;
        return _x;
    }

    @Property(name="tenantOnboardingEligibilityReason")
    @JsonIgnore
    public Optional<TenantOnboardingEligibilityReason> getTenantOnboardingEligibilityReason() {
        return Optional.ofNullable(tenantOnboardingEligibilityReason);
    }

    public TenantStatusInformation withTenantOnboardingEligibilityReason(TenantOnboardingEligibilityReason tenantOnboardingEligibilityReason) {
        TenantStatusInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantStatusInformation");
        _x.tenantOnboardingEligibilityReason = tenantOnboardingEligibilityReason;
        return _x;
    }

    @Property(name="workloadStatuses")
    @JsonIgnore
    public CollectionPage<WorkloadStatus> getWorkloadStatuses() {
        return new CollectionPage<WorkloadStatus>(contextPath, WorkloadStatus.class, this.workloadStatuses, Optional.ofNullable(workloadStatusesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="workloadStatuses")
    @JsonIgnore
    public CollectionPage<WorkloadStatus> getWorkloadStatuses(HttpRequestOptions options) {
        return new CollectionPage<WorkloadStatus>(contextPath, WorkloadStatus.class, this.workloadStatuses, Optional.ofNullable(workloadStatusesNextLink), Collections.emptyList(), options);
    }

    public TenantStatusInformation withUnmappedField(String name, Object value) {
        TenantStatusInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DelegatedPrivilegeStatus delegatedPrivilegeStatus;
        private OffsetDateTime lastDelegatedPrivilegeRefreshDateTime;
        private String offboardedByUserId;
        private OffsetDateTime offboardedDateTime;
        private String onboardedByUserId;
        private OffsetDateTime onboardedDateTime;
        private TenantOnboardingStatus onboardingStatus;
        private TenantOnboardingEligibilityReason tenantOnboardingEligibilityReason;
        private List<WorkloadStatus> workloadStatuses;
        private String workloadStatusesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder delegatedPrivilegeStatus(DelegatedPrivilegeStatus delegatedPrivilegeStatus) {
            this.delegatedPrivilegeStatus = delegatedPrivilegeStatus;
            this.changedFields = changedFields.add("delegatedPrivilegeStatus");
            return this;
        }

        public Builder lastDelegatedPrivilegeRefreshDateTime(OffsetDateTime lastDelegatedPrivilegeRefreshDateTime) {
            this.lastDelegatedPrivilegeRefreshDateTime = lastDelegatedPrivilegeRefreshDateTime;
            this.changedFields = changedFields.add("lastDelegatedPrivilegeRefreshDateTime");
            return this;
        }

        public Builder offboardedByUserId(String offboardedByUserId) {
            this.offboardedByUserId = offboardedByUserId;
            this.changedFields = changedFields.add("offboardedByUserId");
            return this;
        }

        public Builder offboardedDateTime(OffsetDateTime offboardedDateTime) {
            this.offboardedDateTime = offboardedDateTime;
            this.changedFields = changedFields.add("offboardedDateTime");
            return this;
        }

        public Builder onboardedByUserId(String onboardedByUserId) {
            this.onboardedByUserId = onboardedByUserId;
            this.changedFields = changedFields.add("onboardedByUserId");
            return this;
        }

        public Builder onboardedDateTime(OffsetDateTime onboardedDateTime) {
            this.onboardedDateTime = onboardedDateTime;
            this.changedFields = changedFields.add("onboardedDateTime");
            return this;
        }

        public Builder onboardingStatus(TenantOnboardingStatus onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            this.changedFields = changedFields.add("onboardingStatus");
            return this;
        }

        public Builder tenantOnboardingEligibilityReason(TenantOnboardingEligibilityReason tenantOnboardingEligibilityReason) {
            this.tenantOnboardingEligibilityReason = tenantOnboardingEligibilityReason;
            this.changedFields = changedFields.add("tenantOnboardingEligibilityReason");
            return this;
        }

        public Builder workloadStatuses(List<WorkloadStatus> workloadStatuses) {
            this.workloadStatuses = workloadStatuses;
            this.changedFields = changedFields.add("workloadStatuses");
            return this;
        }

        public Builder workloadStatuses(WorkloadStatus... workloadStatuses) {
            return workloadStatuses(Arrays.asList(workloadStatuses));
        }

        public Builder workloadStatusesNextLink(String workloadStatusesNextLink) {
            this.workloadStatusesNextLink = workloadStatusesNextLink;
            this.changedFields = changedFields.add("workloadStatuses");
            return this;
        }

        public TenantStatusInformation build() {
            TenantStatusInformation _x = new TenantStatusInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantStatusInformation";
            _x.delegatedPrivilegeStatus = delegatedPrivilegeStatus;
            _x.lastDelegatedPrivilegeRefreshDateTime = lastDelegatedPrivilegeRefreshDateTime;
            _x.offboardedByUserId = offboardedByUserId;
            _x.offboardedDateTime = offboardedDateTime;
            _x.onboardedByUserId = onboardedByUserId;
            _x.onboardedDateTime = onboardedDateTime;
            _x.onboardingStatus = onboardingStatus;
            _x.tenantOnboardingEligibilityReason = tenantOnboardingEligibilityReason;
            _x.workloadStatuses = workloadStatuses;
            _x.workloadStatusesNextLink = workloadStatusesNextLink;
            return _x;
        }
    }

    private TenantStatusInformation _copy() {
        TenantStatusInformation _x = new TenantStatusInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.delegatedPrivilegeStatus = delegatedPrivilegeStatus;
        _x.lastDelegatedPrivilegeRefreshDateTime = lastDelegatedPrivilegeRefreshDateTime;
        _x.offboardedByUserId = offboardedByUserId;
        _x.offboardedDateTime = offboardedDateTime;
        _x.onboardedByUserId = onboardedByUserId;
        _x.onboardedDateTime = onboardedDateTime;
        _x.onboardingStatus = onboardingStatus;
        _x.tenantOnboardingEligibilityReason = tenantOnboardingEligibilityReason;
        _x.workloadStatuses = workloadStatuses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantStatusInformation[");
        b.append("delegatedPrivilegeStatus=");
        b.append(this.delegatedPrivilegeStatus);
        b.append(", ");
        b.append("lastDelegatedPrivilegeRefreshDateTime=");
        b.append(this.lastDelegatedPrivilegeRefreshDateTime);
        b.append(", ");
        b.append("offboardedByUserId=");
        b.append(this.offboardedByUserId);
        b.append(", ");
        b.append("offboardedDateTime=");
        b.append(this.offboardedDateTime);
        b.append(", ");
        b.append("onboardedByUserId=");
        b.append(this.onboardedByUserId);
        b.append(", ");
        b.append("onboardedDateTime=");
        b.append(this.onboardedDateTime);
        b.append(", ");
        b.append("onboardingStatus=");
        b.append(this.onboardingStatus);
        b.append(", ");
        b.append("tenantOnboardingEligibilityReason=");
        b.append(this.tenantOnboardingEligibilityReason);
        b.append(", ");
        b.append("workloadStatuses=");
        b.append(this.workloadStatuses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
