package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contractType", 
    "defaultDomainName", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class TenantContract implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contractType")
    protected Integer contractType;

    @JsonProperty("defaultDomainName")
    protected String defaultDomainName;

    @JsonProperty("displayName")
    protected String displayName;

    protected TenantContract() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantContract";
    }

    @Property(name="contractType")
    @JsonIgnore
    public Optional<Integer> getContractType() {
        return Optional.ofNullable(contractType);
    }

    public TenantContract withContractType(Integer contractType) {
        TenantContract _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContract");
        _x.contractType = contractType;
        return _x;
    }

    @Property(name="defaultDomainName")
    @JsonIgnore
    public Optional<String> getDefaultDomainName() {
        return Optional.ofNullable(defaultDomainName);
    }

    public TenantContract withDefaultDomainName(String defaultDomainName) {
        TenantContract _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContract");
        _x.defaultDomainName = defaultDomainName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TenantContract withDisplayName(String displayName) {
        TenantContract _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantContract");
        _x.displayName = displayName;
        return _x;
    }

    public TenantContract withUnmappedField(String name, Object value) {
        TenantContract _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer contractType;
        private String defaultDomainName;
        private String displayName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contractType(Integer contractType) {
            this.contractType = contractType;
            this.changedFields = changedFields.add("contractType");
            return this;
        }

        public Builder defaultDomainName(String defaultDomainName) {
            this.defaultDomainName = defaultDomainName;
            this.changedFields = changedFields.add("defaultDomainName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public TenantContract build() {
            TenantContract _x = new TenantContract();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantContract";
            _x.contractType = contractType;
            _x.defaultDomainName = defaultDomainName;
            _x.displayName = displayName;
            return _x;
        }
    }

    private TenantContract _copy() {
        TenantContract _x = new TenantContract();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contractType = contractType;
        _x.defaultDomainName = defaultDomainName;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantContract[");
        b.append("contractType=");
        b.append(this.contractType);
        b.append(", ");
        b.append("defaultDomainName=");
        b.append(this.defaultDomainName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
