package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.ManagementParameterValueType;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "jsonAllowedValues", 
    "jsonDefaultValue", 
    "valueType"})
@JsonInclude(Include.NON_NULL)
public class TemplateParameter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("jsonAllowedValues")
    protected String jsonAllowedValues;

    @JsonProperty("jsonDefaultValue")
    protected String jsonDefaultValue;

    @JsonProperty("valueType")
    protected ManagementParameterValueType valueType;

    protected TemplateParameter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.templateParameter";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TemplateParameter withDescription(String description) {
        TemplateParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateParameter");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TemplateParameter withDisplayName(String displayName) {
        TemplateParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateParameter");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="jsonAllowedValues")
    @JsonIgnore
    public Optional<String> getJsonAllowedValues() {
        return Optional.ofNullable(jsonAllowedValues);
    }

    public TemplateParameter withJsonAllowedValues(String jsonAllowedValues) {
        TemplateParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateParameter");
        _x.jsonAllowedValues = jsonAllowedValues;
        return _x;
    }

    @Property(name="jsonDefaultValue")
    @JsonIgnore
    public Optional<String> getJsonDefaultValue() {
        return Optional.ofNullable(jsonDefaultValue);
    }

    public TemplateParameter withJsonDefaultValue(String jsonDefaultValue) {
        TemplateParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateParameter");
        _x.jsonDefaultValue = jsonDefaultValue;
        return _x;
    }

    @Property(name="valueType")
    @JsonIgnore
    public Optional<ManagementParameterValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    public TemplateParameter withValueType(ManagementParameterValueType valueType) {
        TemplateParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateParameter");
        _x.valueType = valueType;
        return _x;
    }

    public TemplateParameter withUnmappedField(String name, Object value) {
        TemplateParameter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private String jsonAllowedValues;
        private String jsonDefaultValue;
        private ManagementParameterValueType valueType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder jsonAllowedValues(String jsonAllowedValues) {
            this.jsonAllowedValues = jsonAllowedValues;
            this.changedFields = changedFields.add("jsonAllowedValues");
            return this;
        }

        public Builder jsonDefaultValue(String jsonDefaultValue) {
            this.jsonDefaultValue = jsonDefaultValue;
            this.changedFields = changedFields.add("jsonDefaultValue");
            return this;
        }

        public Builder valueType(ManagementParameterValueType valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        public TemplateParameter build() {
            TemplateParameter _x = new TemplateParameter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.templateParameter";
            _x.description = description;
            _x.displayName = displayName;
            _x.jsonAllowedValues = jsonAllowedValues;
            _x.jsonDefaultValue = jsonDefaultValue;
            _x.valueType = valueType;
            return _x;
        }
    }

    private TemplateParameter _copy() {
        TemplateParameter _x = new TemplateParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.jsonAllowedValues = jsonAllowedValues;
        _x.jsonDefaultValue = jsonDefaultValue;
        _x.valueType = valueType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TemplateParameter[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("jsonAllowedValues=");
        b.append(this.jsonAllowedValues);
        b.append(", ");
        b.append("jsonDefaultValue=");
        b.append(this.jsonDefaultValue);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
