package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "service", 
    "settings", 
    "templateActionId"})
@JsonInclude(Include.NON_NULL)
public class TemplateAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("settings")
    protected List<Setting> settings;

    @JsonProperty("settings@nextLink")
    protected String settingsNextLink;

    @JsonProperty("templateActionId")
    protected String templateActionId;

    protected TemplateAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.templateAction";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TemplateAction withDescription(String description) {
        TemplateAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateAction");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TemplateAction withDisplayName(String displayName) {
        TemplateAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateAction");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public TemplateAction withService(String service) {
        TemplateAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateAction");
        _x.service = service;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<Setting> getSettings() {
        return new CollectionPage<Setting>(contextPath, Setting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<Setting> getSettings(HttpRequestOptions options) {
        return new CollectionPage<Setting>(contextPath, Setting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="templateActionId")
    @JsonIgnore
    public Optional<String> getTemplateActionId() {
        return Optional.ofNullable(templateActionId);
    }

    public TemplateAction withTemplateActionId(String templateActionId) {
        TemplateAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.templateAction");
        _x.templateActionId = templateActionId;
        return _x;
    }

    public TemplateAction withUnmappedField(String name, Object value) {
        TemplateAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private String service;
        private List<Setting> settings;
        private String settingsNextLink;
        private String templateActionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder settings(List<Setting> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder settings(Setting... settings) {
            return settings(Arrays.asList(settings));
        }

        public Builder settingsNextLink(String settingsNextLink) {
            this.settingsNextLink = settingsNextLink;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder templateActionId(String templateActionId) {
            this.templateActionId = templateActionId;
            this.changedFields = changedFields.add("templateActionId");
            return this;
        }

        public TemplateAction build() {
            TemplateAction _x = new TemplateAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.templateAction";
            _x.description = description;
            _x.displayName = displayName;
            _x.service = service;
            _x.settings = settings;
            _x.settingsNextLink = settingsNextLink;
            _x.templateActionId = templateActionId;
            return _x;
        }
    }

    private TemplateAction _copy() {
        TemplateAction _x = new TemplateAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.service = service;
        _x.settings = settings;
        _x.templateActionId = templateActionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TemplateAction[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("templateActionId=");
        b.append(this.templateActionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
