package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.ManagementParameterValueType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "jsonValue", 
    "overwriteAllowed", 
    "settingId", 
    "valueType"})
@JsonInclude(Include.NON_NULL)
public class Setting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("jsonValue")
    protected String jsonValue;

    @JsonProperty("overwriteAllowed")
    protected Boolean overwriteAllowed;

    @JsonProperty("settingId")
    protected String settingId;

    @JsonProperty("valueType")
    protected ManagementParameterValueType valueType;

    protected Setting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.setting";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Setting withDisplayName(String displayName) {
        Setting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.setting");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="jsonValue")
    @JsonIgnore
    public Optional<String> getJsonValue() {
        return Optional.ofNullable(jsonValue);
    }

    public Setting withJsonValue(String jsonValue) {
        Setting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.setting");
        _x.jsonValue = jsonValue;
        return _x;
    }

    @Property(name="overwriteAllowed")
    @JsonIgnore
    public Optional<Boolean> getOverwriteAllowed() {
        return Optional.ofNullable(overwriteAllowed);
    }

    public Setting withOverwriteAllowed(Boolean overwriteAllowed) {
        Setting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.setting");
        _x.overwriteAllowed = overwriteAllowed;
        return _x;
    }

    @Property(name="settingId")
    @JsonIgnore
    public Optional<String> getSettingId() {
        return Optional.ofNullable(settingId);
    }

    public Setting withSettingId(String settingId) {
        Setting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.setting");
        _x.settingId = settingId;
        return _x;
    }

    @Property(name="valueType")
    @JsonIgnore
    public Optional<ManagementParameterValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    public Setting withValueType(ManagementParameterValueType valueType) {
        Setting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.setting");
        _x.valueType = valueType;
        return _x;
    }

    public Setting withUnmappedField(String name, Object value) {
        Setting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String jsonValue;
        private Boolean overwriteAllowed;
        private String settingId;
        private ManagementParameterValueType valueType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder jsonValue(String jsonValue) {
            this.jsonValue = jsonValue;
            this.changedFields = changedFields.add("jsonValue");
            return this;
        }

        public Builder overwriteAllowed(Boolean overwriteAllowed) {
            this.overwriteAllowed = overwriteAllowed;
            this.changedFields = changedFields.add("overwriteAllowed");
            return this;
        }

        public Builder settingId(String settingId) {
            this.settingId = settingId;
            this.changedFields = changedFields.add("settingId");
            return this;
        }

        public Builder valueType(ManagementParameterValueType valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        public Setting build() {
            Setting _x = new Setting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.setting";
            _x.displayName = displayName;
            _x.jsonValue = jsonValue;
            _x.overwriteAllowed = overwriteAllowed;
            _x.settingId = settingId;
            _x.valueType = valueType;
            return _x;
        }
    }

    private Setting _copy() {
        Setting _x = new Setting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.jsonValue = jsonValue;
        _x.overwriteAllowed = overwriteAllowed;
        _x.settingId = settingId;
        _x.valueType = valueType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Setting[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("jsonValue=");
        b.append(this.jsonValue);
        b.append(", ");
        b.append("overwriteAllowed=");
        b.append(this.overwriteAllowed);
        b.append(", ");
        b.append("settingId=");
        b.append(this.settingId);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
