package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.ManagementCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "displayName", 
    "managementTemplateId", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ManagementTemplateDetailedInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("category")
    protected ManagementCategory category;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("managementTemplateId")
    protected String managementTemplateId;

    @JsonProperty("version")
    protected Integer version;

    protected ManagementTemplateDetailedInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementTemplateDetailedInfo";
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ManagementCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ManagementTemplateDetailedInfo withCategory(ManagementCategory category) {
        ManagementTemplateDetailedInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateDetailedInfo");
        _x.category = category;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ManagementTemplateDetailedInfo withDisplayName(String displayName) {
        ManagementTemplateDetailedInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateDetailedInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="managementTemplateId")
    @JsonIgnore
    public Optional<String> getManagementTemplateId() {
        return Optional.ofNullable(managementTemplateId);
    }

    public ManagementTemplateDetailedInfo withManagementTemplateId(String managementTemplateId) {
        ManagementTemplateDetailedInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateDetailedInfo");
        _x.managementTemplateId = managementTemplateId;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public ManagementTemplateDetailedInfo withVersion(Integer version) {
        ManagementTemplateDetailedInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementTemplateDetailedInfo");
        _x.version = version;
        return _x;
    }

    public ManagementTemplateDetailedInfo withUnmappedField(String name, Object value) {
        ManagementTemplateDetailedInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ManagementCategory category;
        private String displayName;
        private String managementTemplateId;
        private Integer version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder category(ManagementCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder managementTemplateId(String managementTemplateId) {
            this.managementTemplateId = managementTemplateId;
            this.changedFields = changedFields.add("managementTemplateId");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public ManagementTemplateDetailedInfo build() {
            ManagementTemplateDetailedInfo _x = new ManagementTemplateDetailedInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementTemplateDetailedInfo";
            _x.category = category;
            _x.displayName = displayName;
            _x.managementTemplateId = managementTemplateId;
            _x.version = version;
            return _x;
        }
    }

    private ManagementTemplateDetailedInfo _copy() {
        ManagementTemplateDetailedInfo _x = new ManagementTemplateDetailedInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.category = category;
        _x.displayName = displayName;
        _x.managementTemplateId = managementTemplateId;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementTemplateDetailedInfo[");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("managementTemplateId=");
        b.append(this.managementTemplateId);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
