package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "managementIntentDisplayName", 
    "managementIntentId", 
    "managementTemplates"})
@JsonInclude(Include.NON_NULL)
public class ManagementIntentInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("managementIntentDisplayName")
    protected String managementIntentDisplayName;

    @JsonProperty("managementIntentId")
    protected String managementIntentId;

    @JsonProperty("managementTemplates")
    protected List<ManagementTemplateDetailedInfo> managementTemplates;

    @JsonProperty("managementTemplates@nextLink")
    protected String managementTemplatesNextLink;

    protected ManagementIntentInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementIntentInfo";
    }

    @Property(name="managementIntentDisplayName")
    @JsonIgnore
    public Optional<String> getManagementIntentDisplayName() {
        return Optional.ofNullable(managementIntentDisplayName);
    }

    public ManagementIntentInfo withManagementIntentDisplayName(String managementIntentDisplayName) {
        ManagementIntentInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementIntentInfo");
        _x.managementIntentDisplayName = managementIntentDisplayName;
        return _x;
    }

    @Property(name="managementIntentId")
    @JsonIgnore
    public Optional<String> getManagementIntentId() {
        return Optional.ofNullable(managementIntentId);
    }

    public ManagementIntentInfo withManagementIntentId(String managementIntentId) {
        ManagementIntentInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementIntentInfo");
        _x.managementIntentId = managementIntentId;
        return _x;
    }

    @Property(name="managementTemplates")
    @JsonIgnore
    public CollectionPage<ManagementTemplateDetailedInfo> getManagementTemplates() {
        return new CollectionPage<ManagementTemplateDetailedInfo>(contextPath, ManagementTemplateDetailedInfo.class, this.managementTemplates, Optional.ofNullable(managementTemplatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="managementTemplates")
    @JsonIgnore
    public CollectionPage<ManagementTemplateDetailedInfo> getManagementTemplates(HttpRequestOptions options) {
        return new CollectionPage<ManagementTemplateDetailedInfo>(contextPath, ManagementTemplateDetailedInfo.class, this.managementTemplates, Optional.ofNullable(managementTemplatesNextLink), Collections.emptyList(), options);
    }

    public ManagementIntentInfo withUnmappedField(String name, Object value) {
        ManagementIntentInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String managementIntentDisplayName;
        private String managementIntentId;
        private List<ManagementTemplateDetailedInfo> managementTemplates;
        private String managementTemplatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder managementIntentDisplayName(String managementIntentDisplayName) {
            this.managementIntentDisplayName = managementIntentDisplayName;
            this.changedFields = changedFields.add("managementIntentDisplayName");
            return this;
        }

        public Builder managementIntentId(String managementIntentId) {
            this.managementIntentId = managementIntentId;
            this.changedFields = changedFields.add("managementIntentId");
            return this;
        }

        public Builder managementTemplates(List<ManagementTemplateDetailedInfo> managementTemplates) {
            this.managementTemplates = managementTemplates;
            this.changedFields = changedFields.add("managementTemplates");
            return this;
        }

        public Builder managementTemplates(ManagementTemplateDetailedInfo... managementTemplates) {
            return managementTemplates(Arrays.asList(managementTemplates));
        }

        public Builder managementTemplatesNextLink(String managementTemplatesNextLink) {
            this.managementTemplatesNextLink = managementTemplatesNextLink;
            this.changedFields = changedFields.add("managementTemplates");
            return this;
        }

        public ManagementIntentInfo build() {
            ManagementIntentInfo _x = new ManagementIntentInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementIntentInfo";
            _x.managementIntentDisplayName = managementIntentDisplayName;
            _x.managementIntentId = managementIntentId;
            _x.managementTemplates = managementTemplates;
            _x.managementTemplatesNextLink = managementTemplatesNextLink;
            return _x;
        }
    }

    private ManagementIntentInfo _copy() {
        ManagementIntentInfo _x = new ManagementIntentInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.managementIntentDisplayName = managementIntentDisplayName;
        _x.managementIntentId = managementIntentId;
        _x.managementTemplates = managementTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementIntentInfo[");
        b.append("managementIntentDisplayName=");
        b.append(this.managementIntentDisplayName);
        b.append(", ");
        b.append("managementIntentId=");
        b.append(this.managementIntentId);
        b.append(", ");
        b.append("managementTemplates=");
        b.append(this.managementTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
