package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "managementActionId", 
    "managementTemplateId", 
    "managementTemplateVersion"})
@JsonInclude(Include.NON_NULL)
public class ManagementActionInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("managementActionId")
    protected String managementActionId;

    @JsonProperty("managementTemplateId")
    protected String managementTemplateId;

    @JsonProperty("managementTemplateVersion")
    protected Integer managementTemplateVersion;

    protected ManagementActionInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementActionInfo";
    }

    @Property(name="managementActionId")
    @JsonIgnore
    public Optional<String> getManagementActionId() {
        return Optional.ofNullable(managementActionId);
    }

    public ManagementActionInfo withManagementActionId(String managementActionId) {
        ManagementActionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionInfo");
        _x.managementActionId = managementActionId;
        return _x;
    }

    @Property(name="managementTemplateId")
    @JsonIgnore
    public Optional<String> getManagementTemplateId() {
        return Optional.ofNullable(managementTemplateId);
    }

    public ManagementActionInfo withManagementTemplateId(String managementTemplateId) {
        ManagementActionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionInfo");
        _x.managementTemplateId = managementTemplateId;
        return _x;
    }

    @Property(name="managementTemplateVersion")
    @JsonIgnore
    public Optional<Integer> getManagementTemplateVersion() {
        return Optional.ofNullable(managementTemplateVersion);
    }

    public ManagementActionInfo withManagementTemplateVersion(Integer managementTemplateVersion) {
        ManagementActionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionInfo");
        _x.managementTemplateVersion = managementTemplateVersion;
        return _x;
    }

    public ManagementActionInfo withUnmappedField(String name, Object value) {
        ManagementActionInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String managementActionId;
        private String managementTemplateId;
        private Integer managementTemplateVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder managementActionId(String managementActionId) {
            this.managementActionId = managementActionId;
            this.changedFields = changedFields.add("managementActionId");
            return this;
        }

        public Builder managementTemplateId(String managementTemplateId) {
            this.managementTemplateId = managementTemplateId;
            this.changedFields = changedFields.add("managementTemplateId");
            return this;
        }

        public Builder managementTemplateVersion(Integer managementTemplateVersion) {
            this.managementTemplateVersion = managementTemplateVersion;
            this.changedFields = changedFields.add("managementTemplateVersion");
            return this;
        }

        public ManagementActionInfo build() {
            ManagementActionInfo _x = new ManagementActionInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementActionInfo";
            _x.managementActionId = managementActionId;
            _x.managementTemplateId = managementTemplateId;
            _x.managementTemplateVersion = managementTemplateVersion;
            return _x;
        }
    }

    private ManagementActionInfo _copy() {
        ManagementActionInfo _x = new ManagementActionInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.managementActionId = managementActionId;
        _x.managementTemplateId = managementTemplateId;
        _x.managementTemplateVersion = managementTemplateVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementActionInfo[");
        b.append("managementActionId=");
        b.append(this.managementActionId);
        b.append(", ");
        b.append("managementTemplateId=");
        b.append(this.managementTemplateId);
        b.append(", ");
        b.append("managementTemplateVersion=");
        b.append(this.managementTemplateVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
