package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.enums.ManagementActionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "managementActionId", 
    "managementTemplateId", 
    "managementTemplateVersion", 
    "status", 
    "workloadActionDeploymentStatuses"})
@JsonInclude(Include.NON_NULL)
public class ManagementActionDeploymentStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("managementActionId")
    protected String managementActionId;

    @JsonProperty("managementTemplateId")
    protected String managementTemplateId;

    @JsonProperty("managementTemplateVersion")
    protected Integer managementTemplateVersion;

    @JsonProperty("status")
    protected ManagementActionStatus status;

    @JsonProperty("workloadActionDeploymentStatuses")
    protected List<WorkloadActionDeploymentStatus> workloadActionDeploymentStatuses;

    @JsonProperty("workloadActionDeploymentStatuses@nextLink")
    protected String workloadActionDeploymentStatusesNextLink;

    protected ManagementActionDeploymentStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managementActionDeploymentStatus";
    }

    @Property(name="managementActionId")
    @JsonIgnore
    public Optional<String> getManagementActionId() {
        return Optional.ofNullable(managementActionId);
    }

    public ManagementActionDeploymentStatus withManagementActionId(String managementActionId) {
        ManagementActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionDeploymentStatus");
        _x.managementActionId = managementActionId;
        return _x;
    }

    @Property(name="managementTemplateId")
    @JsonIgnore
    public Optional<String> getManagementTemplateId() {
        return Optional.ofNullable(managementTemplateId);
    }

    public ManagementActionDeploymentStatus withManagementTemplateId(String managementTemplateId) {
        ManagementActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionDeploymentStatus");
        _x.managementTemplateId = managementTemplateId;
        return _x;
    }

    @Property(name="managementTemplateVersion")
    @JsonIgnore
    public Optional<Integer> getManagementTemplateVersion() {
        return Optional.ofNullable(managementTemplateVersion);
    }

    public ManagementActionDeploymentStatus withManagementTemplateVersion(Integer managementTemplateVersion) {
        ManagementActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionDeploymentStatus");
        _x.managementTemplateVersion = managementTemplateVersion;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ManagementActionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ManagementActionDeploymentStatus withStatus(ManagementActionStatus status) {
        ManagementActionDeploymentStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managementActionDeploymentStatus");
        _x.status = status;
        return _x;
    }

    @Property(name="workloadActionDeploymentStatuses")
    @JsonIgnore
    public CollectionPage<WorkloadActionDeploymentStatus> getWorkloadActionDeploymentStatuses() {
        return new CollectionPage<WorkloadActionDeploymentStatus>(contextPath, WorkloadActionDeploymentStatus.class, this.workloadActionDeploymentStatuses, Optional.ofNullable(workloadActionDeploymentStatusesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="workloadActionDeploymentStatuses")
    @JsonIgnore
    public CollectionPage<WorkloadActionDeploymentStatus> getWorkloadActionDeploymentStatuses(HttpRequestOptions options) {
        return new CollectionPage<WorkloadActionDeploymentStatus>(contextPath, WorkloadActionDeploymentStatus.class, this.workloadActionDeploymentStatuses, Optional.ofNullable(workloadActionDeploymentStatusesNextLink), Collections.emptyList(), options);
    }

    public ManagementActionDeploymentStatus withUnmappedField(String name, Object value) {
        ManagementActionDeploymentStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String managementActionId;
        private String managementTemplateId;
        private Integer managementTemplateVersion;
        private ManagementActionStatus status;
        private List<WorkloadActionDeploymentStatus> workloadActionDeploymentStatuses;
        private String workloadActionDeploymentStatusesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder managementActionId(String managementActionId) {
            this.managementActionId = managementActionId;
            this.changedFields = changedFields.add("managementActionId");
            return this;
        }

        public Builder managementTemplateId(String managementTemplateId) {
            this.managementTemplateId = managementTemplateId;
            this.changedFields = changedFields.add("managementTemplateId");
            return this;
        }

        public Builder managementTemplateVersion(Integer managementTemplateVersion) {
            this.managementTemplateVersion = managementTemplateVersion;
            this.changedFields = changedFields.add("managementTemplateVersion");
            return this;
        }

        public Builder status(ManagementActionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder workloadActionDeploymentStatuses(List<WorkloadActionDeploymentStatus> workloadActionDeploymentStatuses) {
            this.workloadActionDeploymentStatuses = workloadActionDeploymentStatuses;
            this.changedFields = changedFields.add("workloadActionDeploymentStatuses");
            return this;
        }

        public Builder workloadActionDeploymentStatuses(WorkloadActionDeploymentStatus... workloadActionDeploymentStatuses) {
            return workloadActionDeploymentStatuses(Arrays.asList(workloadActionDeploymentStatuses));
        }

        public Builder workloadActionDeploymentStatusesNextLink(String workloadActionDeploymentStatusesNextLink) {
            this.workloadActionDeploymentStatusesNextLink = workloadActionDeploymentStatusesNextLink;
            this.changedFields = changedFields.add("workloadActionDeploymentStatuses");
            return this;
        }

        public ManagementActionDeploymentStatus build() {
            ManagementActionDeploymentStatus _x = new ManagementActionDeploymentStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.managementActionDeploymentStatus";
            _x.managementActionId = managementActionId;
            _x.managementTemplateId = managementTemplateId;
            _x.managementTemplateVersion = managementTemplateVersion;
            _x.status = status;
            _x.workloadActionDeploymentStatuses = workloadActionDeploymentStatuses;
            _x.workloadActionDeploymentStatusesNextLink = workloadActionDeploymentStatusesNextLink;
            return _x;
        }
    }

    private ManagementActionDeploymentStatus _copy() {
        ManagementActionDeploymentStatus _x = new ManagementActionDeploymentStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.managementActionId = managementActionId;
        _x.managementTemplateId = managementTemplateId;
        _x.managementTemplateVersion = managementTemplateVersion;
        _x.status = status;
        _x.workloadActionDeploymentStatuses = workloadActionDeploymentStatuses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementActionDeploymentStatus[");
        b.append("managementActionId=");
        b.append(this.managementActionId);
        b.append(", ");
        b.append("managementTemplateId=");
        b.append(this.managementTemplateId);
        b.append(", ");
        b.append("managementTemplateVersion=");
        b.append(this.managementTemplateVersion);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("workloadActionDeploymentStatuses=");
        b.append(this.workloadActionDeploymentStatuses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
