package odata.msgraph.client.beta.managed.tenants.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class ManagedTenantOperationError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("error")
    protected String error;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected ManagedTenantOperationError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.managedTenantOperationError";
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public ManagedTenantOperationError withError(String error) {
        ManagedTenantOperationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantOperationError");
        _x.error = error;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ManagedTenantOperationError withTenantId(String tenantId) {
        ManagedTenantOperationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.managedTenantOperationError");
        _x.tenantId = tenantId;
        return _x;
    }

    public ManagedTenantOperationError withUnmappedField(String name, Object value) {
        ManagedTenantOperationError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private ManagedTenantOperationError _copy() {
        ManagedTenantOperationError _x = new ManagedTenantOperationError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.error = error;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedTenantOperationError[");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
