package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WorkforceIntegrationSupportedEntities implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("shift")
    SHIFT("shift", "1"),

    @JsonProperty("swapRequest")
    SWAP_REQUEST("swapRequest", "2"),

    @JsonProperty("userShiftPreferences")
    USER_SHIFT_PREFERENCES("userShiftPreferences", "8"),

    @JsonProperty("openShift")
    OPEN_SHIFT("openShift", "16"),

    @JsonProperty("openShiftRequest")
    OPEN_SHIFT_REQUEST("openShiftRequest", "32"),

    @JsonProperty("offerShiftRequest")
    OFFER_SHIFT_REQUEST("offerShiftRequest", "64"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1024"),

    @JsonProperty("timeCard")
    TIME_CARD("timeCard", "2048"),

    @JsonProperty("timeOffReason")
    TIME_OFF_REASON("timeOffReason", "4096"),

    @JsonProperty("timeOff")
    TIME_OFF("timeOff", "8192"),

    @JsonProperty("timeOffRequest")
    TIME_OFF_REQUEST("timeOffRequest", "16384");

    private final String name;
    private final String value;

    private WorkforceIntegrationSupportedEntities(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
