package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsSModeConfiguration implements Enum {

    @JsonProperty("noRestriction")
    NO_RESTRICTION("noRestriction", "0"),

    @JsonProperty("block")
    BLOCK("block", "1"),

    @JsonProperty("unlock")
    UNLOCK("unlock", "2");

    private final String name;
    private final String value;

    private WindowsSModeConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
