package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsQualityUpdateClassification implements Enum {

    @JsonProperty("all")
    ALL("all", "0"),

    @JsonProperty("security")
    SECURITY("security", "1"),

    @JsonProperty("nonSecurity")
    NON_SECURITY("nonSecurity", "2");

    private final String name;
    private final String value;

    private WindowsQualityUpdateClassification(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
