package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsEdgeKioskType implements Enum {

    @JsonProperty("publicBrowsing")
    PUBLIC_BROWSING("publicBrowsing", "0"),

    @JsonProperty("fullScreen")
    FULL_SCREEN("fullScreen", "1");

    private final String name;
    private final String value;

    private WindowsEdgeKioskType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
