package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsDefenderProductStatus implements Enum {

    @JsonProperty("noStatus")
    NO_STATUS("noStatus", "0"),

    @JsonProperty("serviceNotRunning")
    SERVICE_NOT_RUNNING("serviceNotRunning", "1"),

    @JsonProperty("serviceStartedWithoutMalwareProtection")
    SERVICE_STARTED_WITHOUT_MALWARE_PROTECTION("serviceStartedWithoutMalwareProtection", "2"),

    @JsonProperty("pendingFullScanDueToThreatAction")
    PENDING_FULL_SCAN_DUE_TO_THREAT_ACTION("pendingFullScanDueToThreatAction", "4"),

    @JsonProperty("pendingRebootDueToThreatAction")
    PENDING_REBOOT_DUE_TO_THREAT_ACTION("pendingRebootDueToThreatAction", "8"),

    @JsonProperty("pendingManualStepsDueToThreatAction")
    PENDING_MANUAL_STEPS_DUE_TO_THREAT_ACTION("pendingManualStepsDueToThreatAction", "16"),

    @JsonProperty("avSignaturesOutOfDate")
    AV_SIGNATURES_OUT_OF_DATE("avSignaturesOutOfDate", "32"),

    @JsonProperty("asSignaturesOutOfDate")
    AS_SIGNATURES_OUT_OF_DATE("asSignaturesOutOfDate", "64"),

    @JsonProperty("noQuickScanHappenedForSpecifiedPeriod")
    NO_QUICK_SCAN_HAPPENED_FOR_SPECIFIED_PERIOD("noQuickScanHappenedForSpecifiedPeriod", "128"),

    @JsonProperty("noFullScanHappenedForSpecifiedPeriod")
    NO_FULL_SCAN_HAPPENED_FOR_SPECIFIED_PERIOD("noFullScanHappenedForSpecifiedPeriod", "256"),

    @JsonProperty("systemInitiatedScanInProgress")
    SYSTEM_INITIATED_SCAN_IN_PROGRESS("systemInitiatedScanInProgress", "512"),

    @JsonProperty("systemInitiatedCleanInProgress")
    SYSTEM_INITIATED_CLEAN_IN_PROGRESS("systemInitiatedCleanInProgress", "1024"),

    @JsonProperty("samplesPendingSubmission")
    SAMPLES_PENDING_SUBMISSION("samplesPendingSubmission", "2048"),

    @JsonProperty("productRunningInEvaluationMode")
    PRODUCT_RUNNING_IN_EVALUATION_MODE("productRunningInEvaluationMode", "4096"),

    @JsonProperty("productRunningInNonGenuineMode")
    PRODUCT_RUNNING_IN_NON_GENUINE_MODE("productRunningInNonGenuineMode", "8192"),

    @JsonProperty("productExpired")
    PRODUCT_EXPIRED("productExpired", "16384"),

    @JsonProperty("offlineScanRequired")
    OFFLINE_SCAN_REQUIRED("offlineScanRequired", "32768"),

    @JsonProperty("serviceShutdownAsPartOfSystemShutdown")
    SERVICE_SHUTDOWN_AS_PART_OF_SYSTEM_SHUTDOWN("serviceShutdownAsPartOfSystemShutdown", "65536"),

    @JsonProperty("threatRemediationFailedCritically")
    THREAT_REMEDIATION_FAILED_CRITICALLY("threatRemediationFailedCritically", "131072"),

    @JsonProperty("threatRemediationFailedNonCritically")
    THREAT_REMEDIATION_FAILED_NON_CRITICALLY("threatRemediationFailedNonCritically", "262144"),

    @JsonProperty("noStatusFlagsSet")
    NO_STATUS_FLAGS_SET("noStatusFlagsSet", "524288"),

    @JsonProperty("platformOutOfDate")
    PLATFORM_OUT_OF_DATE("platformOutOfDate", "1048576"),

    @JsonProperty("platformUpdateInProgress")
    PLATFORM_UPDATE_IN_PROGRESS("platformUpdateInProgress", "2097152"),

    @JsonProperty("platformAboutToBeOutdated")
    PLATFORM_ABOUT_TO_BE_OUTDATED("platformAboutToBeOutdated", "4194304"),

    @JsonProperty("signatureOrPlatformEndOfLifeIsPastOrIsImpending")
    SIGNATURE_OR_PLATFORM_END_OF_LIFE_IS_PAST_OR_IS_IMPENDING("signatureOrPlatformEndOfLifeIsPastOrIsImpending", "8388608"),

    @JsonProperty("windowsSModeSignaturesInUseOnNonWin10SInstall")
    WINDOWS_SMODE_SIGNATURES_IN_USE_ON_NON_WIN10SINSTALL("windowsSModeSignaturesInUseOnNonWin10SInstall", "16777216");

    private final String name;
    private final String value;

    private WindowsDefenderProductStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
