package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsAutopilotProfileAssignmentStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("assignedInSync")
    ASSIGNED_IN_SYNC("assignedInSync", "1"),

    @JsonProperty("assignedOutOfSync")
    ASSIGNED_OUT_OF_SYNC("assignedOutOfSync", "2"),

    @JsonProperty("assignedUnkownSyncState")
    ASSIGNED_UNKOWN_SYNC_STATE("assignedUnkownSyncState", "3"),

    @JsonProperty("notAssigned")
    NOT_ASSIGNED("notAssigned", "4"),

    @JsonProperty("pending")
    PENDING("pending", "5"),

    @JsonProperty("failed")
    FAILED("failed", "6");

    private final String name;
    private final String value;

    private WindowsAutopilotProfileAssignmentStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
