package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsAutopilotDeploymentState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("success")
    SUCCESS("success", "1"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "2"),

    @JsonProperty("failure")
    FAILURE("failure", "3"),

    @JsonProperty("successWithTimeout")
    SUCCESS_WITH_TIMEOUT("successWithTimeout", "4"),

    @JsonProperty("notAttempted")
    NOT_ATTEMPTED("notAttempted", "5"),

    @JsonProperty("disabled")
    DISABLED("disabled", "6");

    private final String name;
    private final String value;

    private WindowsAutopilotDeploymentState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
