package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WindowsAppStartLayoutTileSize implements Enum {

    @JsonProperty("hidden")
    HIDDEN("hidden", "0"),

    @JsonProperty("small")
    SMALL("small", "1"),

    @JsonProperty("medium")
    MEDIUM("medium", "2"),

    @JsonProperty("wide")
    WIDE("wide", "3"),

    @JsonProperty("large")
    LARGE("large", "4");

    private final String name;
    private final String value;

    private WindowsAppStartLayoutTileSize(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
