package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Windows10VpnAuthenticationMethod implements Enum {

    @JsonProperty("certificate")
    CERTIFICATE("certificate", "0"),

    @JsonProperty("usernameAndPassword")
    USERNAME_AND_PASSWORD("usernameAndPassword", "1"),

    @JsonProperty("customEapXml")
    CUSTOM_EAP_XML("customEapXml", "2"),

    @JsonProperty("derivedCredential")
    DERIVED_CREDENTIAL("derivedCredential", "3");

    private final String name;
    private final String value;

    private Windows10VpnAuthenticationMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
