package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Win32LobAppPowerShellScriptDetectionType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("string")
    STRING("string", "1"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "2"),

    @JsonProperty("integer")
    INTEGER("integer", "3"),

    @JsonProperty("float")
    FLOAT("float", "4"),

    @JsonProperty("version")
    VERSION("version", "5"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "6");

    private final String name;
    private final String value;

    private Win32LobAppPowerShellScriptDetectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
