package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Win32LobAppMsiPackageType implements Enum {

    @JsonProperty("perMachine")
    PER_MACHINE("perMachine", "0"),

    @JsonProperty("perUser")
    PER_USER("perUser", "1"),

    @JsonProperty("dualPurpose")
    DUAL_PURPOSE("dualPurpose", "2");

    private final String name;
    private final String value;

    private Win32LobAppMsiPackageType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
