package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Win32LobAppDetectionOperator implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("equal")
    EQUAL("equal", "1"),

    @JsonProperty("notEqual")
    NOT_EQUAL("notEqual", "2"),

    @JsonProperty("greaterThan")
    GREATER_THAN("greaterThan", "4"),

    @JsonProperty("greaterThanOrEqual")
    GREATER_THAN_OR_EQUAL("greaterThanOrEqual", "5"),

    @JsonProperty("lessThan")
    LESS_THAN("lessThan", "8"),

    @JsonProperty("lessThanOrEqual")
    LESS_THAN_OR_EQUAL("lessThanOrEqual", "9");

    private final String name;
    private final String value;

    private Win32LobAppDetectionOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
