package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WebsiteType implements Enum {

    @JsonProperty("other")
    OTHER("other", "0"),

    @JsonProperty("home")
    HOME("home", "1"),

    @JsonProperty("work")
    WORK("work", "2"),

    @JsonProperty("blog")
    BLOG("blog", "3"),

    @JsonProperty("profile")
    PROFILE("profile", "4");

    private final String name;
    private final String value;

    private WebsiteType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
