package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VppTokenState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("valid")
    VALID("valid", "1"),

    @JsonProperty("expired")
    EXPIRED("expired", "2"),

    @JsonProperty("invalid")
    INVALID("invalid", "3"),

    @JsonProperty("assignedToExternalMDM")
    ASSIGNED_TO_EXTERNAL_MDM("assignedToExternalMDM", "4"),

    @JsonProperty("duplicateLocationId")
    DUPLICATE_LOCATION_ID("duplicateLocationId", "5");

    private final String name;
    private final String value;

    private VppTokenState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
