package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnServerCertificateType implements Enum {

    @JsonProperty("rsa")
    RSA("rsa", "0"),

    @JsonProperty("ecdsa256")
    ECDSA256("ecdsa256", "1"),

    @JsonProperty("ecdsa384")
    ECDSA384("ecdsa384", "2"),

    @JsonProperty("ecdsa521")
    ECDSA521("ecdsa521", "3");

    private final String name;
    private final String value;

    private VpnServerCertificateType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
