package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnOnDemandRuleConnectionAction implements Enum {

    @JsonProperty("connect")
    CONNECT("connect", "0"),

    @JsonProperty("evaluateConnection")
    EVALUATE_CONNECTION("evaluateConnection", "1"),

    @JsonProperty("ignore")
    IGNORE("ignore", "2"),

    @JsonProperty("disconnect")
    DISCONNECT("disconnect", "3");

    private final String name;
    private final String value;

    private VpnOnDemandRuleConnectionAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
