package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnLocalIdentifier implements Enum {

    @JsonProperty("deviceFQDN")
    DEVICE_FQDN("deviceFQDN", "0"),

    @JsonProperty("empty")
    EMPTY("empty", "1"),

    @JsonProperty("clientCertificateSubjectName")
    CLIENT_CERTIFICATE_SUBJECT_NAME("clientCertificateSubjectName", "2");

    private final String name;
    private final String value;

    private VpnLocalIdentifier(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
