package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum VpnEncryptionAlgorithmType implements Enum {

    @JsonProperty("aes256")
    AES256("aes256", "0"),

    @JsonProperty("des")
    DES("des", "1"),

    @JsonProperty("tripleDes")
    TRIPLE_DES("tripleDes", "2"),

    @JsonProperty("aes128")
    AES128("aes128", "3"),

    @JsonProperty("aes128Gcm")
    AES128GCM("aes128Gcm", "4"),

    @JsonProperty("aes256Gcm")
    AES256GCM("aes256Gcm", "5"),

    @JsonProperty("aes192")
    AES192("aes192", "6"),

    @JsonProperty("aes192Gcm")
    AES192GCM("aes192Gcm", "7"),

    @JsonProperty("chaCha20Poly1305")
    CHA_CHA20POLY1305("chaCha20Poly1305", "8");

    private final String name;
    private final String value;

    private VpnEncryptionAlgorithmType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
