package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum UserExperienceAnalyticsOperatingSystemRestartCategory implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("restartWithUpdate")
    RESTART_WITH_UPDATE("restartWithUpdate", "1"),

    @JsonProperty("restartWithoutUpdate")
    RESTART_WITHOUT_UPDATE("restartWithoutUpdate", "2"),

    @JsonProperty("blueScreen")
    BLUE_SCREEN("blueScreen", "3"),

    @JsonProperty("shutdownWithUpdate")
    SHUTDOWN_WITH_UPDATE("shutdownWithUpdate", "4"),

    @JsonProperty("shutdownWithoutUpdate")
    SHUTDOWN_WITHOUT_UPDATE("shutdownWithoutUpdate", "5"),

    @JsonProperty("longPowerButtonPress")
    LONG_POWER_BUTTON_PRESS("longPowerButtonPress", "6"),

    @JsonProperty("bootError")
    BOOT_ERROR("bootError", "7"),

    @JsonProperty("update")
    UPDATE("update", "8");

    private final String name;
    private final String value;

    private UserExperienceAnalyticsOperatingSystemRestartCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
