package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TranslationBehavior implements Enum {

    @JsonProperty("Ask")
    ASK("Ask", "0"),

    @JsonProperty("Yes")
    YES("Yes", "1"),

    @JsonProperty("No")
    NO("No", "2");

    private final String name;
    private final String value;

    private TranslationBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
