package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TokenIssuerType implements Enum {

    @JsonProperty("AzureAD")
    AZURE_AD("AzureAD", "0"),

    @JsonProperty("ADFederationServices")
    ADFEDERATION_SERVICES("ADFederationServices", "1"),

    @JsonProperty("UnknownFutureValue")
    UNKNOWN_FUTURE_VALUE("UnknownFutureValue", "2"),

    @JsonProperty("AzureADBackupAuth")
    AZURE_ADBACKUP_AUTH("AzureADBackupAuth", "3"),

    @JsonProperty("ADFederationServicesMFAAdapter")
    ADFEDERATION_SERVICES_MFAADAPTER("ADFederationServicesMFAAdapter", "4"),

    @JsonProperty("NPSExtension")
    NPSEXTENSION("NPSExtension", "5");

    private final String name;
    private final String value;

    private TokenIssuerType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
