package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TimeOffReasonIconType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("car")
    CAR("car", "1"),

    @JsonProperty("calendar")
    CALENDAR("calendar", "2"),

    @JsonProperty("running")
    RUNNING("running", "3"),

    @JsonProperty("plane")
    PLANE("plane", "4"),

    @JsonProperty("firstAid")
    FIRST_AID("firstAid", "5"),

    @JsonProperty("doctor")
    DOCTOR("doctor", "6"),

    @JsonProperty("notWorking")
    NOT_WORKING("notWorking", "7"),

    @JsonProperty("clock")
    CLOCK("clock", "8"),

    @JsonProperty("juryDuty")
    JURY_DUTY("juryDuty", "9"),

    @JsonProperty("globe")
    GLOBE("globe", "10"),

    @JsonProperty("cup")
    CUP("cup", "11"),

    @JsonProperty("phone")
    PHONE("phone", "12"),

    @JsonProperty("weather")
    WEATHER("weather", "13"),

    @JsonProperty("umbrella")
    UMBRELLA("umbrella", "14"),

    @JsonProperty("piggyBank")
    PIGGY_BANK("piggyBank", "15"),

    @JsonProperty("dog")
    DOG("dog", "16"),

    @JsonProperty("cake")
    CAKE("cake", "17"),

    @JsonProperty("trafficCone")
    TRAFFIC_CONE("trafficCone", "18"),

    @JsonProperty("pin")
    PIN("pin", "19"),

    @JsonProperty("sunny")
    SUNNY("sunny", "20"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "21");

    private final String name;
    private final String value;

    private TimeOffReasonIconType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
