package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkSupportedClient implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("skypeDefaultAndTeams")
    SKYPE_DEFAULT_AND_TEAMS("skypeDefaultAndTeams", "1"),

    @JsonProperty("teamsDefaultAndSkype")
    TEAMS_DEFAULT_AND_SKYPE("teamsDefaultAndSkype", "2"),

    @JsonProperty("skypeOnly")
    SKYPE_ONLY("skypeOnly", "3"),

    @JsonProperty("teamsOnly")
    TEAMS_ONLY("teamsOnly", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private TeamworkSupportedClient(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
