package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkSoftwareType implements Enum {

    @JsonProperty("adminAgent")
    ADMIN_AGENT("adminAgent", "0"),

    @JsonProperty("operatingSystem")
    OPERATING_SYSTEM("operatingSystem", "1"),

    @JsonProperty("teamsClient")
    TEAMS_CLIENT("teamsClient", "2"),

    @JsonProperty("firmware")
    FIRMWARE("firmware", "3"),

    @JsonProperty("partnerAgent")
    PARTNER_AGENT("partnerAgent", "4"),

    @JsonProperty("companyPortal")
    COMPANY_PORTAL("companyPortal", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private TeamworkSoftwareType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
