package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkDeviceType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("ipPhone")
    IP_PHONE("ipPhone", "1"),

    @JsonProperty("teamsRoom")
    TEAMS_ROOM("teamsRoom", "2"),

    @JsonProperty("surfaceHub")
    SURFACE_HUB("surfaceHub", "3"),

    @JsonProperty("collaborationBar")
    COLLABORATION_BAR("collaborationBar", "4"),

    @JsonProperty("teamsDisplay")
    TEAMS_DISPLAY("teamsDisplay", "5"),

    @JsonProperty("touchConsole")
    TOUCH_CONSOLE("touchConsole", "6"),

    @JsonProperty("lowCostPhone")
    LOW_COST_PHONE("lowCostPhone", "7"),

    @JsonProperty("teamsPanel")
    TEAMS_PANEL("teamsPanel", "8"),

    @JsonProperty("sip")
    SIP("sip", "9"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "10");

    private final String name;
    private final String value;

    private TeamworkDeviceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
