package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamworkDeviceOperationType implements Enum {

    @JsonProperty("deviceRestart")
    DEVICE_RESTART("deviceRestart", "0"),

    @JsonProperty("configUpdate")
    CONFIG_UPDATE("configUpdate", "1"),

    @JsonProperty("deviceDiagnostics")
    DEVICE_DIAGNOSTICS("deviceDiagnostics", "2"),

    @JsonProperty("softwareUpdate")
    SOFTWARE_UPDATE("softwareUpdate", "3"),

    @JsonProperty("deviceManagementAgentConfigUpdate")
    DEVICE_MANAGEMENT_AGENT_CONFIG_UPDATE("deviceManagementAgentConfigUpdate", "4"),

    @JsonProperty("remoteLogin")
    REMOTE_LOGIN("remoteLogin", "5"),

    @JsonProperty("remoteLogout")
    REMOTE_LOGOUT("remoteLogout", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private TeamworkDeviceOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
