package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TeamSpecialization implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("educationStandard")
    EDUCATION_STANDARD("educationStandard", "1"),

    @JsonProperty("educationClass")
    EDUCATION_CLASS("educationClass", "2"),

    @JsonProperty("educationProfessionalLearningCommunity")
    EDUCATION_PROFESSIONAL_LEARNING_COMMUNITY("educationProfessionalLearningCommunity", "3"),

    @JsonProperty("educationStaff")
    EDUCATION_STAFF("educationStaff", "4"),

    @JsonProperty("healthcareStandard")
    HEALTHCARE_STANDARD("healthcareStandard", "5"),

    @JsonProperty("healthcareCareCoordination")
    HEALTHCARE_CARE_COORDINATION("healthcareCareCoordination", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private TeamSpecialization(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
