package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SynchronizationSecret implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("UserName")
    USER_NAME("UserName", "1"),

    @JsonProperty("Password")
    PASSWORD("Password", "2"),

    @JsonProperty("SecretToken")
    SECRET_TOKEN("SecretToken", "3"),

    @JsonProperty("AppKey")
    APP_KEY("AppKey", "4"),

    @JsonProperty("BaseAddress")
    BASE_ADDRESS("BaseAddress", "5"),

    @JsonProperty("ClientIdentifier")
    CLIENT_IDENTIFIER("ClientIdentifier", "6"),

    @JsonProperty("ClientSecret")
    CLIENT_SECRET("ClientSecret", "7"),

    @JsonProperty("SingleSignOnType")
    SINGLE_SIGN_ON_TYPE("SingleSignOnType", "11"),

    @JsonProperty("Sandbox")
    SANDBOX("Sandbox", "12"),

    @JsonProperty("Url")
    URL("Url", "13"),

    @JsonProperty("Domain")
    DOMAIN("Domain", "14"),

    @JsonProperty("ConsumerKey")
    CONSUMER_KEY("ConsumerKey", "15"),

    @JsonProperty("ConsumerSecret")
    CONSUMER_SECRET("ConsumerSecret", "16"),

    @JsonProperty("TokenKey")
    TOKEN_KEY("TokenKey", "17"),

    @JsonProperty("TokenExpiration")
    TOKEN_EXPIRATION("TokenExpiration", "18"),

    @JsonProperty("Oauth2AccessToken")
    OAUTH2ACCESS_TOKEN("Oauth2AccessToken", "19"),

    @JsonProperty("Oauth2AccessTokenCreationTime")
    OAUTH2ACCESS_TOKEN_CREATION_TIME("Oauth2AccessTokenCreationTime", "20"),

    @JsonProperty("Oauth2RefreshToken")
    OAUTH2REFRESH_TOKEN("Oauth2RefreshToken", "21"),

    @JsonProperty("SyncAll")
    SYNC_ALL("SyncAll", "22"),

    @JsonProperty("InstanceName")
    INSTANCE_NAME("InstanceName", "24"),

    @JsonProperty("Oauth2ClientId")
    OAUTH2CLIENT_ID("Oauth2ClientId", "27"),

    @JsonProperty("Oauth2ClientSecret")
    OAUTH2CLIENT_SECRET("Oauth2ClientSecret", "28"),

    @JsonProperty("CompanyId")
    COMPANY_ID("CompanyId", "29"),

    @JsonProperty("UpdateKeyOnSoftDelete")
    UPDATE_KEY_ON_SOFT_DELETE("UpdateKeyOnSoftDelete", "30"),

    @JsonProperty("SynchronizationSchedule")
    SYNCHRONIZATION_SCHEDULE("SynchronizationSchedule", "33"),

    @JsonProperty("SystemOfRecord")
    SYSTEM_OF_RECORD("SystemOfRecord", "34"),

    @JsonProperty("SandboxName")
    SANDBOX_NAME("SandboxName", "35"),

    @JsonProperty("EnforceDomain")
    ENFORCE_DOMAIN("EnforceDomain", "36"),

    @JsonProperty("SyncNotificationSettings")
    SYNC_NOTIFICATION_SETTINGS("SyncNotificationSettings", "37"),

    @JsonProperty("SkipOutOfScopeDeletions")
    SKIP_OUT_OF_SCOPE_DELETIONS("SkipOutOfScopeDeletions", "40"),

    @JsonProperty("Oauth2AuthorizationCode")
    OAUTH2AUTHORIZATION_CODE("Oauth2AuthorizationCode", "62"),

    @JsonProperty("Oauth2RedirectUri")
    OAUTH2REDIRECT_URI("Oauth2RedirectUri", "63"),

    @JsonProperty("ApplicationTemplateIdentifier")
    APPLICATION_TEMPLATE_IDENTIFIER("ApplicationTemplateIdentifier", "64"),

    @JsonProperty("Oauth2TokenExchangeUri")
    OAUTH2TOKEN_EXCHANGE_URI("Oauth2TokenExchangeUri", "65"),

    @JsonProperty("Oauth2AuthorizationUri")
    OAUTH2AUTHORIZATION_URI("Oauth2AuthorizationUri", "66"),

    @JsonProperty("AuthenticationType")
    AUTHENTICATION_TYPE("AuthenticationType", "67"),

    @JsonProperty("Server")
    SERVER("Server", "70"),

    @JsonProperty("PerformInboundEntitlementGrants")
    PERFORM_INBOUND_ENTITLEMENT_GRANTS("PerformInboundEntitlementGrants", "100"),

    @JsonProperty("HardDeletesEnabled")
    HARD_DELETES_ENABLED("HardDeletesEnabled", "101"),

    @JsonProperty("SyncAgentCompatibilityKey")
    SYNC_AGENT_COMPATIBILITY_KEY("SyncAgentCompatibilityKey", "102"),

    @JsonProperty("SyncAgentADContainer")
    SYNC_AGENT_ADCONTAINER("SyncAgentADContainer", "103"),

    @JsonProperty("ValidateDomain")
    VALIDATE_DOMAIN("ValidateDomain", "206"),

    @JsonProperty("TestReferences")
    TEST_REFERENCES("TestReferences", "207"),

    @JsonProperty("ConnectionString")
    CONNECTION_STRING("ConnectionString", "250");

    private final String name;
    private final String value;

    private SynchronizationSecret(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
