package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SubjectRightsRequestType implements Enum {

    @JsonProperty("export")
    EXPORT("export", "0"),

    @JsonProperty("delete")
    DELETE("delete", "1"),

    @JsonProperty("access")
    ACCESS("access", "2"),

    @JsonProperty("tagForAction")
    TAG_FOR_ACTION("tagForAction", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private SubjectRightsRequestType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
