package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SubjectRightsRequestStageStatus implements Enum {

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "0"),

    @JsonProperty("current")
    CURRENT("current", "1"),

    @JsonProperty("completed")
    COMPLETED("completed", "3"),

    @JsonProperty("failed")
    FAILED("failed", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private SubjectRightsRequestStageStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
